/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.ow2.petals.admin.registry;

import java.util.List;

/**
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public class Endpoint {

    public enum EndpointType {INTERNAL,EXTERNAL}
    
    private String endpointName;
    
    private EndpointType endpointType;

    private String containerName;
    
    private String componentName;
    
    private String serviceName;
    
    private List<String> interfaceNames;

    public Endpoint(String endpointName, EndpointType endpointType, String containerName, String componentName, String serviceName,
            List<String> interfaceNames) {
        assert endpointName != null;
        assert endpointType != null;
        assert containerName != null;
        assert componentName != null;
        assert serviceName != null;
        assert interfaceNames != null;
      
        this.endpointName = endpointName;
        this.endpointType = endpointType;
        this.containerName = containerName;
        this.componentName = componentName;
        this.serviceName = serviceName;
        this.interfaceNames = interfaceNames;
    }
    
    public String getEndpointName() {
        return endpointName;
    }
    
    public EndpointType getEndpointType() {
        return endpointType;
    }

    public String getContainerName() {
        return containerName;
    }

    public String getComponentName() {
        return componentName;
    }

    public String getServiceName() {
        return serviceName;
    }

    public List<String> getInterfaceNames() {
        return interfaceNames;
    }
}
