/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.ow2.petals.admin.topology;

import java.util.HashMap;


/**
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public class Container {

    public enum NodeType {MASTER,PEER,SLAVE,STANDALONE}

    public enum PortType {
        
        JMX("JMX port"),
        HTTP_WEBSERVICE("HTTP Webservice port"),
        REGISTRY("Registry port"),
        TCP_TRANSPORT("TCP port");
        
        private String displayValue;
        
        PortType(String displayValue) {
            this.displayValue = displayValue;
        }
    
        public String toString(){
            return this.displayValue;
        }
    }
    
    private String containerName;
    
    private NodeType nodeType;

    private String host;
    
    private HashMap<PortType, Integer> ports;
    
    public Container(String containerName, NodeType nodeType, String host, HashMap<PortType, Integer> ports) {
        assert  containerName != null;
        assert  nodeType != null;
        assert  host != null;
        assert  ports != null;
        
        this.containerName = containerName;
        this.nodeType = nodeType;
        this.host = host;
        this.ports = ports;
    }
    
    public String getContainerName() {
        return this.containerName;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }
    
    public String getHost() {
        return this.host;
    }
    
    public HashMap<PortType, Integer> getPorts() {
        return this.ports;
    }
}
