/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.ow2.petals.admin.topology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public class Domain {

    private String name;

    private List<Subdomain> subdomains;

    public Domain(String name) {
        assert name != null;
        
        this.name = name;
        this.subdomains = new ArrayList<Subdomain>();
    }
    
    public void addSubdomain(List<Subdomain> subdomains) {
        assert subdomains != null;

        this.subdomains.addAll(subdomains);
    }
    
    public String getName() {
        return name;
    }
    
    public List<Subdomain> getSubdomains() {
        return Collections.unmodifiableList(this.subdomains);
    }   
}
