package org.ow2.petals.admin.topology;

/****************************************************************************
*
* Copyright (c) 2010-2012, EBM WebSourcing
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
*
*****************************************************************************/

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 
 * @author Nicolas Oddoux - EBM WebSourcing
 */
public class Subdomain {

    private String name;

    private List<Container> containers;

    public Subdomain(String name) {
        assert name != null;
        
        this.name = name;
        this.containers = new ArrayList<Container>();
    }
    
    public void addContainers(List<Container> containers) {
        assert containers != null;

        this.containers.addAll(containers);
    }
    
    public String getName() {
        return name;
    }
    
    public List<Container> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }   
}
