/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.api;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.ArtifactException;
import org.ow2.petals.admin.api.artifact.ArtifactUtils;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.SharedLibrary;
import org.ow2.petals.admin.api.artifact.lifecycle.ArtifactLifecycle;
import org.ow2.petals.admin.api.artifact.lifecycle.ArtifactLifecycleFactory;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.api.exception.ArtifactNotDeployedException;
import org.ow2.petals.admin.api.exception.ArtifactNotFoundException;
import org.ow2.petals.admin.api.exception.ArtifactStartedException;
import org.ow2.petals.admin.api.exception.ArtifactStoppedException;
import org.ow2.petals.admin.api.exception.ArtifactTypeIsNeededException;
import org.ow2.petals.admin.api.exception.UnsupportedArtifactTypeException;

public abstract class ArtifactAdministration {
    protected ArtifactAdministration() {
    }

    private final void deployAndStart(Artifact artifact, URL artifactUrl) throws ArtifactAdministrationException {
        ArtifactLifecycle artifactLifecycle = ArtifactLifecycleFactory.newInstance(artifact);
        artifactLifecycle.deploy(artifactUrl);
        artifactLifecycle.start();
    }

    public void deployAndStartArtifact(URL artifactUrl) throws ArtifactAdministrationException {
        try {
            Artifact artifact = ArtifactUtils.createArtifact(artifactUrl);
            this.deployAndStart(artifact, artifactUrl);
        }
        catch (ArtifactException ae) {
            throw new ArtifactAdministrationException(ae);
        }
    }

    public void deployAndStartArtifact(URL artifactUrl, Properties configurationProperties) throws ArtifactAdministrationException {
        try {
            Artifact artifact = ArtifactUtils.createArtifact(artifactUrl, configurationProperties);
            this.deployAndStart(artifact, artifactUrl);
        }
        catch (ArtifactException ae) {
            throw new ArtifactAdministrationException(ae);
        }
    }

    public void deployAndStartArtifact(URL artifactUrl, URL configurationFile) throws ArtifactAdministrationException {
        try {
            Artifact artifact = ArtifactUtils.createArtifact(artifactUrl, configurationFile);
            this.deployAndStart(artifact, artifactUrl);
        }
        catch (ArtifactException ae) {
            throw new ArtifactAdministrationException(ae);
        }
    }

    public void startArtifact(URL artifactUrl) throws ArtifactStartedException, ArtifactNotDeployedException, ArtifactNotFoundException, ArtifactAdministrationException {
        try {
            Artifact artifact = ArtifactUtils.createArtifact(artifactUrl);
            this.startArtifact(artifact);
        }
        catch (ArtifactException ae) {
            throw new ArtifactAdministrationException(ae);
        }
    }

    public void startArtifact(String type, String name) throws UnsupportedArtifactTypeException, ArtifactNotFoundException, ArtifactTypeIsNeededException, ArtifactStartedException, ArtifactNotDeployedException, ArtifactAdministrationException {
        Artifact artifact = this.getArtifact(type, name);
        this.startArtifact(artifact);
    }

    private void startArtifact(Artifact artifact) throws ArtifactStartedException, ArtifactNotDeployedException, ArtifactNotFoundException, ArtifactAdministrationException {
        assert (artifact != null) : "artifact is null";
        ArtifactLifecycle artifactLifecycle = ArtifactLifecycleFactory.newInstance(artifact);
        artifactLifecycle.start();
    }

    public void stopArtifact(URL artifactUrl) throws ArtifactAdministrationException {
        try {
            Artifact artifact = ArtifactUtils.createArtifact(artifactUrl);
            ArtifactLifecycle artifactLifecycle = ArtifactLifecycleFactory.newInstance(artifact);
            artifactLifecycle.stop();
        }
        catch (ArtifactException ae) {
            throw new ArtifactAdministrationException(ae);
        }
    }

    public void stopArtifact(String type, String name) throws UnsupportedArtifactTypeException, ArtifactNotFoundException, ArtifactTypeIsNeededException, ArtifactAdministrationException {
        Artifact artifact = this.getArtifact(type, name);
        ArtifactLifecycle artifactLifecycle = ArtifactLifecycleFactory.newInstance(artifact);
        artifactLifecycle.stop();
    }

    public void stopAndUndeployArtifact(URL artifactUrl) throws ArtifactAdministrationException {
        try {
            Artifact artifact = ArtifactUtils.createArtifact(artifactUrl);
            this.stopAndUndeployArtifact(artifact);
        }
        catch (ArtifactException ae) {
            throw new ArtifactAdministrationException(ae);
        }
    }

    public void stopAndUndeployArtifact(String type, String name) throws UnsupportedArtifactTypeException, ArtifactNotFoundException, ArtifactTypeIsNeededException, ArtifactAdministrationException {
        Artifact artifact = this.getArtifact(type, name);
        this.stopAndUndeployArtifact(artifact);
    }

    private void stopAndUndeployArtifact(Artifact artifact) throws ArtifactAdministrationException {
        ArtifactLifecycle artifactLifecycle = ArtifactLifecycleFactory.newInstance(artifact);
        try {
            artifactLifecycle.stop();
        }
        catch (ArtifactStoppedException e) {
        }
        catch (ArtifactNotDeployedException artifactNotDeployedException) {
            // empty catch block
        }
        artifactLifecycle.undeploy();
    }

    public Artifact getArtifactInfo(URL artifactUrl) throws ArtifactAdministrationException {
        try {
            Artifact artifact = ArtifactUtils.createArtifact(artifactUrl);
            ArtifactLifecycle artifactLifecycle = ArtifactLifecycleFactory.newInstance(artifact);
            artifactLifecycle.updateState();
            return artifact;
        }
        catch (ArtifactException ae) {
            throw new ArtifactAdministrationException(ae);
        }
    }

    public Artifact getArtifactInfo(String type, String name) throws UnsupportedArtifactTypeException, ArtifactNotFoundException, ArtifactTypeIsNeededException, ArtifactAdministrationException {
        Artifact artifact = this.getArtifact(type, name);
        ArtifactLifecycle artifactLifecycle = ArtifactLifecycleFactory.newInstance(artifact);
        artifactLifecycle.updateState();
        return artifact;
    }

    public void deployAndStartArtifacts(URL[] artifactsUrl) throws ArtifactAdministrationException {
        HashMap<URL, Artifact> sls = new HashMap<URL, Artifact>();
        HashMap<URL, Artifact> components = new HashMap<URL, Artifact>();
        HashMap<URL, Artifact> sas = new HashMap<URL, Artifact>();
        HashMap<URL, Artifact> unknows = new HashMap<URL, Artifact>();
        for (URL url : artifactsUrl) {
            try {
                Artifact artifact = ArtifactUtils.createArtifact(url);
                if (artifact instanceof SharedLibrary) {
                    sls.put(url, artifact);
                    continue;
                }
                if (artifact instanceof Component) {
                    components.put(url, artifact);
                    continue;
                }
                if (artifact instanceof ServiceAssembly) {
                    sas.put(url, artifact);
                    continue;
                }
                unknows.put(url, artifact);
            }
            catch (ArtifactException e) {
                throw new ArtifactAdministrationException(e);
            }
        }
        LinkedHashMap<URL, Artifact> maps = new LinkedHashMap<URL, Artifact>();
        maps.putAll(sls);
        maps.putAll(components);
        maps.putAll(sas);
        maps.putAll(unknows);
        for (Map.Entry entry : maps.entrySet()) {
            this.deployAndStart((Artifact)entry.getValue(), (URL)entry.getKey());
        }
    }

    public abstract void stopAndUndeployAllArtifacts() throws ArtifactAdministrationException;

    public abstract List<Artifact> listArtifacts() throws ArtifactAdministrationException;

    public abstract Artifact getArtifact(String var1, String var2) throws UnsupportedArtifactTypeException, ArtifactNotFoundException, ArtifactTypeIsNeededException, ArtifactAdministrationException;
}

