/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package org.ow2.petals.kernel.ws.client;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.ArtifactRepositoryService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.to.AttachmentDescriptor;

/**
 * @author Adrien Ruffié - eBM WebSourcing
 * Provider a client for the artifact repository
 * service of the petals-kernel-wsapi
 */
public class ArtifactRepositoryServiceClient implements ArtifactRepositoryService {

    // Proxy client
    final ArtifactRepositoryService client;

    ArtifactRepositoryServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(ArtifactRepositoryService.class);
        factory.setAddress(address);
        this.client = (ArtifactRepositoryService) factory.create();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.ArtifactRepositoryService#addArtifact(org
     * .ow2.petals.kernel.ws.api.to.AttachmentDescriptor)
     */
    public boolean addArtifact(final AttachmentDescriptor attachmentDescriptor)
            throws PEtALSWebServiceException {
        return this.client.addArtifact(attachmentDescriptor);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.ArtifactRepositoryService#getComponents()
     */
    public String[] getComponents() {
        String[] components = this.client.getComponents();
        if(components == null){
            components = new String[0];
        }
        return components;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.ArtifactRepositoryService#getServiceAssemblies
     * ()
     */
    public String[] getServiceAssemblies() {
        String[] sas = this.client.getServiceAssemblies();
        if(sas == null){
            sas = new String[0];
        }
        return sas;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.ArtifactRepositoryService#getSharedLibraries
     * ()
     */
    public String[] getSharedLibraries() {
        String[] sls = this.client.getSharedLibraries();
        if(sls == null){
            sls = new String[0];
        }
        return sls;
    }

}
