/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package org.ow2.petals.kernel.ws.client;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.DeploymentService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;

/**
 * @author Adrien Ruffié - eBM WebSourcing
 * Provider a client for the deployment
 * service of the petals-kernel-wsapi
 */
public class DeploymentServiceClient implements DeploymentService {

    // Proxy client
    final DeploymentService client;

    DeploymentServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(DeploymentService.class);
        factory.setAddress(address);
        this.client = (DeploymentService) factory.create();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.DeploymentService#deploy(java.lang.String)
     */
    public boolean deploy(final String saId) throws PEtALSWebServiceException {
        return this.client.deploy(saId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.DeploymentService#shutdown(java.lang.String)
     */
    public boolean shutdown(final String saId) throws PEtALSWebServiceException {
        return this.client.shutdown(saId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.DeploymentService#start(java.lang.String)
     */
    public boolean start(final String saId) throws PEtALSWebServiceException {
        return this.client.start(saId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.DeploymentService#stop(java.lang.String)
     */
    public boolean stop(final String saId) throws PEtALSWebServiceException {
        return this.client.stop(saId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.DeploymentService#undeploy(java.lang.String)
     */
    public boolean undeploy(final String saId) throws PEtALSWebServiceException {
        return this.client.undeploy(saId);
    }

}
