/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.kernel.ws.client;

import java.util.ArrayList;
import java.util.List;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.EndpointService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.to.Endpoint;
import org.ow2.petals.kernel.ws.api.to.EndpointQuery;

/**
 * @author Adrien Ruffié - eBM WebSourcing
 * Provider a client for the endpoint
 * service of the petals-kernel-wsapi
 */
public class EndpointServiceClient implements EndpointService {

    // Proxy client
    final EndpointService client;

    EndpointServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(EndpointService.class);
        factory.setAddress(address);
        this.client = (EndpointService) factory.create();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.kernel.ws.api.EndpointService#getEndpoints()
     */
    public List<Endpoint> getEndpoints() throws PEtALSWebServiceException {
        List<Endpoint> endpoints = this.client.getEndpoints();
        if(endpoints == null){
            endpoints = new ArrayList<Endpoint>();
        }
        return endpoints;
    }

    /**
     * {@inheritDoc}
     */
    public List<Endpoint> query(EndpointQuery query) throws PEtALSWebServiceException {
        List<Endpoint> endpoints = this.client.query(query);
        if(endpoints == null){
            endpoints = new ArrayList<Endpoint>();
        }
        return endpoints;
    }

}
