/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package org.ow2.petals.kernel.ws.client;

import java.net.URL;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.InstallationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;

/**
 * @author Adrien Ruffié - eBM WebSourcing
 * Provider a client for the installation
 * service of the petals-kernel-wsapi
 */
public class InstallationServiceClient implements InstallationService {

    // Proxy client
    final InstallationService client;

    InstallationServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(InstallationService.class);
        factory.setAddress(address);
        this.client = (InstallationService) factory.create();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.InstallationService#install(java.lang.String
     * )
     */
    public boolean install(final String componentId) throws PEtALSWebServiceException {
        return this.client.install(componentId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.InstallationService#install(java.net.URL)
     */
    public boolean install(final URL url) throws PEtALSWebServiceException {
        return this.client.install(url);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.InstallationService#uninstall(java.lang.
     * String)
     */
    public boolean uninstall(final String componentId) throws PEtALSWebServiceException {
        return this.client.uninstall(componentId);
    }

}
