/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.kernel.ws.client;

import java.util.ArrayList;
import java.util.List;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.JBIArtefactsService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.to.Component;
import org.ow2.petals.kernel.ws.api.to.ServiceAssembly;
import org.ow2.petals.kernel.ws.api.to.SharedLib;

/**
 * @author Adrien Ruffié - eBM WebSourcing
 * Provider a client for the jbi artefacts
 * service of the petals-kernel-wsapi
 */
public class JBIArtefactsServiceClient implements JBIArtefactsService {

    // Proxy client
    final JBIArtefactsService client;

    JBIArtefactsServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(JBIArtefactsService.class);
        factory.setAddress(address);
        this.client = (JBIArtefactsService) factory.create();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.kernel.ws.api.JBIArtefactsService#getComponents()
     */
    public List<Component> getComponents() throws PEtALSWebServiceException {
        List<Component> components = this.client.getComponents();
        if(components == null){
            components = new ArrayList<Component>();
        }
        return components;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.JBIArtefactsService#getServiceAssemblies()
     */
    public List<ServiceAssembly> getServiceAssemblies() throws PEtALSWebServiceException {
        List<ServiceAssembly> sas = this.client.getServiceAssemblies();
        if(sas == null){
            sas = new ArrayList<ServiceAssembly>();
        }
        return sas;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.JBIArtefactsService#getSharedLibraries()
     */
    public List<SharedLib> getSharedLibraries() throws PEtALSWebServiceException {
        List<SharedLib> sls = this.client.getSharedLibraries();
        if(sls == null){
            sls = new ArrayList<SharedLib>();
        }
        return sls;
    }

}
