/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package org.ow2.petals.kernel.ws.client;

import javax.xml.namespace.QName;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.MonitoringManagementService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;

/**
 * @author Adrien Ruffié - eBM WebSourcing
 * Provider a client for the monitoring management
 * service of the petals-kernel-wsapi
 */
public class MonitoringManagementServiceClient implements MonitoringManagementService {

    // Proxy client
    final MonitoringManagementService client;

    MonitoringManagementServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(MonitoringManagementService.class);
        factory.setAddress(address);
        this.client = (MonitoringManagementService) factory.create();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.MonitoringManagementService#activateMonitoring
     * (javax.xml.namespace.QName)
     */
    public boolean activateMonitoring(final QName module) throws PEtALSWebServiceException {
        return this.client.activateMonitoring(module);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.MonitoringManagementService#activateMonitoring
     * (javax.xml.namespace.QName[])
     */
    public boolean activateMonitoring(final QName[] modules) throws PEtALSWebServiceException {
        return this.client.activateMonitoring(modules);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.MonitoringManagementService#disableMonitoring
     * (javax.xml.namespace.QName)
     */
    public boolean disableMonitoring(final QName module) throws PEtALSWebServiceException {
        return this.client.disableMonitoring(module);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.MonitoringManagementService#disableMonitoring
     * (javax.xml.namespace.QName[])
     */
    public boolean disableMonitoring(final QName[] modules) throws PEtALSWebServiceException {
        return this.client.disableMonitoring(modules);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.MonitoringManagementService#getMonitoredModules
     * ()
     */
    public QName[] getMonitoredModules() throws PEtALSWebServiceException {
        QName[] modules = this.client.getMonitoredModules();
        if(modules == null){
            modules = new QName[0];
        }
        return modules;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.MonitoringManagementService#isMonitoringActive
     * (javax.xml.namespace.QName)
     */
    public boolean isMonitoringActive(final QName module) throws PEtALSWebServiceException {
        return this.client.isMonitoringActive(module);
    }

}
