/**
 * PETALS: PETALS Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package org.ow2.petals.kernel.ws.client;

import java.util.HashMap;
import java.util.Map;

import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;

/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public class PetalsClientFactory {
    private static PetalsClientFactory instance = null;

    private final Map<String, PetalsClient> clients;

    private final static long TIMEOUT = 60000L;

    /**
     * @return the instance
     */
    public synchronized static PetalsClientFactory getInstance() {
        if (instance == null) {
            instance = new PetalsClientFactory();
        }
        return instance;
    }

    private PetalsClientFactory() {
        this.clients = new HashMap<String, PetalsClient>();
    }

    public synchronized PetalsClient getClient(String baseURL) throws PEtALSWebServiceException {
        return this.getClient(baseURL, TIMEOUT);
    }

    public synchronized PetalsClient getClient(String baseURL, final long timeout)
            throws PEtALSWebServiceException {
        PetalsClient result = this.clients.get(baseURL);
        if (result == null) {
            result = new CXFPetalsClient(baseURL);
            result.init(timeout);
            this.clients.put(baseURL, result);
        }
        return result;
    }

    public void releaseClient(String baseURL) {
        this.clients.remove(baseURL);
    }

}
