/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package org.ow2.petals.kernel.ws.client;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.RuntimeService;

/**
 * @author Adrien Ruffié - eBM WebSourcing
 * Provider a client for the runtime
 * service of the petals-kernel-wsapi
 */
public class RuntimeServiceClient implements RuntimeService {

    // Proxy client
    final RuntimeService client;

    RuntimeServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(RuntimeService.class);
        factory.setAddress(address);
        this.client = (RuntimeService) factory.create();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.kernel.ws.api.RuntimeService#ping()
     */
    public boolean ping() throws PEtALSWebServiceException {
        return this.client.ping();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.kernel.ws.api.RuntimeService#shutdownContainer()
     */
    public void shutdownContainer() throws PEtALSWebServiceException {
        this.client.shutdownContainer();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.kernel.ws.api.RuntimeService#stopContainer()
     */
    public void stopContainer() throws PEtALSWebServiceException {
        this.client.stopContainer();
    }

}
