/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package org.ow2.petals.kernel.ws.client;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.ServiceAssemblyStateService;

/**
 * @author Adrien Ruffié - eBM WebSourcing
 * Provider a client for the service assembly
 * state service of the petals-kernel-wsapi
 */
public class ServiceAssemblyStateServiceClient implements ServiceAssemblyStateService {

    // Proxy client
    final ServiceAssemblyStateService client;

    ServiceAssemblyStateServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(ServiceAssemblyStateService.class);
        factory.setAddress(address);
        this.client = (ServiceAssemblyStateService) factory.create();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.ServiceAssemblyStateService#isShutdown(java
     * .lang.String)
     */
    public boolean isShutdown(final String saId) throws PEtALSWebServiceException {
        return this.client.isShutdown(saId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.ServiceAssemblyStateService#isStarted(java
     * .lang.String)
     */
    public boolean isStarted(final String saId) throws PEtALSWebServiceException {
        return this.client.isStarted(saId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.kernel.ws.api.ServiceAssemblyStateService#isStopped(java
     * .lang.String)
     */
    public boolean isStopped(final String saId) throws PEtALSWebServiceException {
        return this.client.isStopped(saId);
    }

    /**
     * {@inheritDoc}
     */
    public boolean isUnknown(String saId) throws PEtALSWebServiceException {
        return this.client.isShutdown(saId);
    }

}
