/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package org.ow2.petals.kernel.ws.client;

import java.util.ArrayList;
import java.util.List;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.TopologyService;
import org.ow2.petals.kernel.ws.api.to.ContainerInformation;
import org.ow2.petals.kernel.ws.api.to.DomainInformation;
import org.ow2.petals.kernel.ws.api.to.JndiInformation;
import org.ow2.petals.kernel.ws.api.to.SubdomainInformation;
import org.ow2.petals.kernel.ws.api.to.SubdomainInformation.SubdomainMode;

/**
 * @author Adrien Ruffié - eBM WebSourcing Provider a client for the topology
 *         service of the petals-kernel-wsapi
 */
public class TopologyServiceClient implements TopologyService {

    // Proxy client
    final TopologyService client;

    TopologyServiceClient(final String address) {
        final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(TopologyService.class);
        factory.setAddress(address);
        this.client = (TopologyService) factory.create();
    }

    /**
     * {@inheritDoc}
     */
    public void addContainerInformation(ContainerInformation addedContainer, String subdomainName) throws PEtALSWebServiceException {
        this.client.addContainerInformation(addedContainer, subdomainName);
    }

    /**
     * {@inheritDoc}
     */
    public JndiInformation getJndiInformation() throws PEtALSWebServiceException {
        return this.client.getJndiInformation();
    }

    /**
     * {@inheritDoc}
     */
    public List<ContainerInformation> getAllContainerInformation() throws PEtALSWebServiceException {
        List<ContainerInformation> infos = this.client.getAllContainerInformation();
        if(infos == null){
            infos = new ArrayList<ContainerInformation>();;
        }
        return infos;
    }

    /**
     * {@inheritDoc}
     */
    public List<ContainerInformation> getMasterContainerInformation() throws PEtALSWebServiceException {
        List<ContainerInformation> infos = this.client.getMasterContainerInformation();
        if(infos == null){
            infos = new ArrayList<ContainerInformation>();;
        }
        return infos;
    }

    /**
     * {@inheritDoc}
     */
    public List<ContainerInformation> getAllSlaveContainerInformationForLocalSubdomain() throws PEtALSWebServiceException {
        List<ContainerInformation> infos = this.client.getAllSlaveContainerInformationForLocalSubdomain();
        if(infos == null){
            infos = new ArrayList<ContainerInformation>();;
        }
        return infos;
    }

    /**
     * {@inheritDoc}
     */
    public List<ContainerInformation> getAllPeerContainerInformationForLocalSubdomain() throws PEtALSWebServiceException {
        List<ContainerInformation> infos = this.client.getAllPeerContainerInformationForLocalSubdomain();
        if(infos == null){
            infos = new ArrayList<ContainerInformation>();;
        }
        return infos;
    }


    /**
     * {@inheritDoc}
     */
    public ContainerInformation getContainerInformation(String containerId)
            throws PEtALSWebServiceException {
        return this.client.getContainerInformation(containerId);
    }

    public void removeContainerInformation(String containerName) throws PEtALSWebServiceException {
        this.client.removeContainerInformation(containerName);
    }

    /**
     * {@inheritDoc}
     */
    public SubdomainInformation getSubdomainByName(String subdomainName) throws PEtALSWebServiceException {
        return this.client.getSubdomainByName(subdomainName);
    }

    public void removeSubdomain(String subdomainName) throws PEtALSWebServiceException {
        this.client.removeSubdomain(subdomainName);
    }

    /**
     * {@inheritDoc}
     */
    public void addSubdomain(String name, String description, SubdomainMode subdomainMode, boolean networkTimeSynchronized) throws PEtALSWebServiceException {
        this.client.addSubdomain(name, description, subdomainMode, networkTimeSynchronized);
    }

    /**
     * {@inheritDoc}
     */
    public void addSubdomainWithContainers(SubdomainInformation subdomain) throws PEtALSWebServiceException {
        this.client.addSubdomainWithContainers(subdomain);
    }


    public DomainInformation getDomainInformation() throws PEtALSWebServiceException {
        return this.client.getDomainInformation();
    }
}
