/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.ws.client;

import java.util.HashMap;
import java.util.Map;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.client.CXFPetalsClient;
import org.ow2.petals.kernel.ws.client.PetalsClient;

public class PetalsClientFactory {
    private static PetalsClientFactory instance = null;
    private final Map<String, PetalsClient> clients = new HashMap<String, PetalsClient>();
    private static final long TIMEOUT = 60000L;

    public static synchronized PetalsClientFactory getInstance() {
        if (instance == null) {
            instance = new PetalsClientFactory();
        }
        return instance;
    }

    private PetalsClientFactory() {
    }

    public synchronized PetalsClient getClient(String baseURL) throws PEtALSWebServiceException {
        return this.getClient(baseURL, 60000L);
    }

    public synchronized PetalsClient getClient(String baseURL, long timeout) throws PEtALSWebServiceException {
        PetalsClient result = this.clients.get(baseURL);
        if (result == null) {
            result = new CXFPetalsClient(baseURL);
            result.init(timeout);
            this.clients.put(baseURL, result);
        }
        return result;
    }

    public void releaseClient(String baseURL) {
        this.clients.remove(baseURL);
    }
}

