/**
 * Synapse - Enterprise Collaborative Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * AdvisorInterceptor.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;

/**
 * @author mcarpentier
 * 
 * Used to match and set method with the rights annotation
 * 
 */
public abstract class AdvisorInterceptor extends StaticMethodMatcherPointcutAdvisor implements
MethodInterceptor {

    private static final long serialVersionUID = 8310448620719669197L;

    protected Logger logger = Logger.getLogger(AdvisorInterceptor.class);

    protected Class<? extends Annotation> annotationType;

    protected Annotation annotationTarget;

    public AdvisorInterceptor() {
        this.setAdvice(this);
    }

    public abstract Object invoke(MethodInvocation arg0) throws Throwable;

    @SuppressWarnings("unchecked")
    public boolean matches(final Method method, final Class targetClass) {
        boolean result = false;
        final Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            Annotation annot;
            for (int i = 0; ((i < annotations.length) && (!result)); i++) {
                annot = annotations[i];
                if (this.annotationType.isAssignableFrom(annot.getClass())) {
                    this.annotationTarget = annot;
                    result = true;
                }
            }
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    public void setAnnotation(final String annotation) {
        try {
            this.annotationType = (Class<? extends Annotation>) Thread.currentThread()
            .getContextClassLoader().loadClass(annotation);
        } catch (final ClassNotFoundException e) {
            throw new NullPointerException();
        }
    }

}
