/**
 * Synapse - Enterprise Collaborative Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CheckInterceptor.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.aop;

import org.aopalliance.intercept.MethodInvocation;

import com.ebmwebsourcing.commons.aop.annotation.CheckArgumentsNotNull;
import com.ebmwebsourcing.commons.aop.exception.NullArgumentException;

/**
 * @author mcarpentier
 * 
 * Throw an exception if one of the annotated method arguments is null
 * 
 */
public class CheckArgumentsNotNullInterceptor extends AdvisorInterceptor {

    private static final long serialVersionUID = -7050293049733531334L;

    @Override
    public Object invoke(final MethodInvocation method) throws Throwable {
        final Object[] args = method.getArguments();
        for (int i = 0; i < args.length; i++) {
            if (args[i] == null) {
                final CheckArgumentsNotNull checker = (CheckArgumentsNotNull) this.annotationTarget;
                throw new NullArgumentException("Argument " + i + " : is null");
            }
        }
        return method.proceed();
    }

}
