/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.jbi.sugenerator.client;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SaBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBeanForSa;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.XmlAttribute;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.XmlElement;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.FileImporter;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiNameFormatter;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiXmlGenerator;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiZipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiArchiveGenerator {
    private static JbiArchiveGenerator instance = new JbiArchiveGenerator();

    private JbiArchiveGenerator() {
    }

    public static JbiArchiveGenerator getInstance() {
        return instance;
    }

    public final File createJbiArchive(Map<URL, String> filesToImportUrls, File temporaryFolder, SuBean suBean, File saZipFile) throws IllegalArgumentException, FileImporter.FileImportsException, IOException {
        HashMap<SuBean, Map<URL, String>> files = new HashMap<SuBean, Map<URL, String>>();
        files.put(suBean, filesToImportUrls);
        ArrayList<SuBean> suBeans = new ArrayList<SuBean>();
        suBeans.add(suBean);
        if (saZipFile.isDirectory()) {
            String saName = JbiNameFormatter.createSaName(suBean.getSuType(), suBean.getServiceName(), suBean.isConsume());
            saZipFile = new File(saZipFile, saName);
        }
        return this.createJbiArchive(suBeans, files, saZipFile, temporaryFolder);
    }

    public final File createJbiArchive(List<SuBean> suBeans, Map<SuBean, Map<URL, String>> filesToImportUrls, File saZipFile, File temporaryFolder) throws IllegalArgumentException, FileImporter.FileImportsException, IOException {
        for (File file : temporaryFolder.listFiles()) {
            if (file.isHidden()) continue;
            file.delete();
        }
        for (File file : temporaryFolder.listFiles()) {
            if (file.isHidden() || file.getName().startsWith(".")) continue;
            throw new IllegalArgumentException("Temporary folder " + temporaryFolder.getAbsolutePath() + " is not empty.");
        }
        File subFolder = new File(temporaryFolder, "subFolder");
        if (!subFolder.mkdir()) {
            throw new IOException("Temporary sub folder " + subFolder.getAbsolutePath() + " could not be created.");
        }
        ArrayList<SuBeanForSa> sus = new ArrayList<SuBeanForSa>();
        ArrayList<File> suZipFiles = new ArrayList<File>();
        for (SuBean suBean : suBeans) {
            this.createJbiSuContent(suBean, filesToImportUrls.get(suBean), subFolder);
            SuBeanForSa suBeanForSa = new SuBeanForSa(suBean);
            sus.add(suBeanForSa);
            File suZipFile = new File(temporaryFolder, suBeanForSa.getZipArtifact());
            JbiZipper.getInstance().createSuZipFile(suZipFile, subFolder);
            suZipFiles.add(suZipFile);
            for (File file : subFolder.listFiles()) {
                if (file.isHidden() || file.getName().startsWith(".")) continue;
                file.delete();
            }
        }
        subFolder.delete();
        SaBean saBean = new SaBean();
        saBean.setSus(sus);
        String saName = saZipFile.isDirectory() ? saZipFile.getName() : JbiNameFormatter.removeFileExtension(saZipFile.getName());
        saBean.setSaName(saName);
        saBean.setDescription("Service assembly archive for " + sus.size() + (sus.size() > 1 ? " service units." : " service unit."));
        this.createJbiSaContent(saBean, temporaryFolder, suZipFiles, saZipFile);
        for (File file : temporaryFolder.listFiles()) {
            if (file.equals(saZipFile) || file.isHidden() || file.getName().startsWith(".")) continue;
            file.delete();
        }
        return saZipFile;
    }

    public final void createJbiSuContent(SuBean suBean, Map<URL, String> filesToImport, File temporaryFolder) throws IOException, IllegalArgumentException, FileImporter.FileImportsException {
        Map<Object, Object> renamedFiles = Collections.emptyMap();
        if (filesToImport != null) {
            renamedFiles = FileImporter.getInstance().importFiles(filesToImport, temporaryFolder, false, true, true);
        }
        for (Map.Entry entry : renamedFiles.entrySet()) {
            List<XmlAttribute> attributes;
            List<XmlElement> elements = suBean.urlsToElements.get(entry.getKey());
            if (elements != null) {
                for (XmlElement element : elements) {
                    element.setValue((String)entry.getValue());
                }
            }
            if ((attributes = suBean.urlsToAttributes.get(entry.getKey())) == null) continue;
            for (XmlAttribute attribute : attributes) {
                attribute.setValue((String)entry.getValue());
            }
        }
        String suJbiXmlContent = JbiXmlGenerator.getInstance().generateJbiXmlFileForSu(suBean);
        File suJbiXml = new File(temporaryFolder, "jbi.xml");
        try {
            if (!suJbiXml.exists()) {
                suJbiXml.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FileWriter writer = new FileWriter(suJbiXml);
        writer.write(suJbiXmlContent);
        writer.close();
    }

    public final void createJbiSaContent(SaBean saBean, File temporaryFolder, List<File> suZipFiles, File saZipFile) throws IOException {
        String saJbiXmlContent = JbiXmlGenerator.getInstance().generateJbiXmlFileForSa(saBean);
        File saJbiXml = new File(temporaryFolder, "jbi.xml");
        try {
            if (!saJbiXml.exists()) {
                saJbiXml.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FileWriter writer = new FileWriter(saJbiXml);
        writer.write(saJbiXmlContent);
        writer.close();
        if (saZipFile.isDirectory()) {
            saZipFile = new File(saZipFile, saBean.getSaName() + ".zip");
        }
        JbiZipper.getInstance().createSaZipFile(saZipFile, suZipFiles, saJbiXml);
    }
}

