/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.jbi.sugenerator.utils;

import com.ebmwebsourcing.commons.jbi.sugenerator.utils.Zipper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiZipper {
    private static JbiZipper instance = new JbiZipper();

    private JbiZipper() {
    }

    public static JbiZipper getInstance() {
        return instance;
    }

    private void addRecursiveFiles(File rootFolder, String folderEntry, Map<String, File> filesToZip) {
        for (File file : rootFolder.listFiles()) {
            if (file.isHidden() || file.getName().startsWith(".")) continue;
            if (!folderEntry.equals("") && !folderEntry.endsWith("/")) {
                folderEntry = folderEntry + "/";
            }
            if (!file.isDirectory()) {
                filesToZip.put(folderEntry + file.getName(), file);
                continue;
            }
            this.addRecursiveFiles(file, folderEntry + file.getName(), filesToZip);
        }
    }

    public File createSuZipFile(File zipFile, List<File> rootFiles) throws IllegalArgumentException, IOException {
        if (!zipFile.getName().endsWith(".zip")) {
            throw new IllegalArgumentException(zipFile.getAbsolutePath() + " does not have a valid zip file name.");
        }
        HashMap<String, File> filesToZip = new HashMap<String, File>();
        for (File file : rootFiles) {
            if (!file.exists() || file.isHidden() || file.getName().startsWith(".")) continue;
            if (file.getName().equals("jbi.xml") && !"META-INF".equals(file.getParentFile().getName())) {
                filesToZip.put("META-INF/jbi.xml", file);
                continue;
            }
            if (!file.isDirectory()) {
                filesToZip.put(file.getName(), file);
                continue;
            }
            this.addRecursiveFiles(file, file.getName(), filesToZip);
        }
        return Zipper.getInstance().createZipFile(zipFile, filesToZip);
    }

    public File createSuZipFile(File zipFile, File folderContainer) throws IOException, IllegalArgumentException {
        if (!folderContainer.isDirectory()) {
            throw new IllegalArgumentException(folderContainer.getAbsolutePath() + " is not a directory.");
        }
        List<File> rootFiles = Arrays.asList(folderContainer.listFiles());
        return this.createSuZipFile(zipFile, rootFiles);
    }

    public File createSuZipFile(String zipFilePath, File folderContainer) throws IOException, IllegalArgumentException {
        return this.createSuZipFile(new File(zipFilePath), folderContainer);
    }

    public File createSaZipFile(File zipFile, List<File> suZipFiles, File saJbiXml) throws IOException {
        if (!zipFile.getName().endsWith(".zip")) {
            throw new IllegalArgumentException(zipFile.getAbsolutePath() + " does not have a valid zip file name.");
        }
        HashMap<String, File> filesToZip = new HashMap<String, File>();
        filesToZip.put("META-INF/jbi.xml", saJbiXml);
        for (File file : suZipFiles) {
            if (file.isHidden() || file.getName().startsWith(".")) continue;
            filesToZip.put(file.getName(), file);
        }
        return Zipper.getInstance().createZipFile(zipFile, filesToZip);
    }

    public File createSaZipFile(File zipFile, File suZipFile, File saJbiXml) throws IOException {
        ArrayList<File> suZipFiles = new ArrayList<File>();
        suZipFiles.add(suZipFile);
        return this.createSaZipFile(zipFile, suZipFiles, saJbiXml);
    }
}

