/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.schema;

import java.util.Map;
import java.util.logging.Logger;

import org.apache.commons.lang.NotImplementedException;

import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaReader;
import com.ebmwebsourcing.commons.schema.api.SchemaWriter;
import com.ebmwebsourcing.commons.schema.api.SchemaReader.FeatureConstants;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchemaReader;

/**
 * This class is a concrete implementation of the abstract class
 * SchemaFactory. Some ideas used here have been shamelessly
 * copied from the wonderful JAXP and Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SchemaFactoryImpl extends SchemaFactory
{


	/**
	 * Create a new instance of a Definition, with an instance
	 * of a PopulatedExtensionRegistry as its ExtensionRegistry.
	 *
	 * @see com.ibm.wsdl.extensions.PopulatedExtensionRegistry
	 */
	public Schema newSchema()
	{
		throw new NotImplementedException();
	}

	/**
	 * Create a new instance of a SchemaReader.
	 */
	public SchemaReader newSchemaReader()
	{
		SchemaReader reader = new com.ebmwebsourcing.commons.schema.impl.SchemaReader();
		return reader;
	}


	/**
	 * Create a new instance of a SchemaReader.
	 */
	public SchemaReader newSchemaReader(Map<FeatureConstants, Object> features){
		SchemaReader reader = newSchemaReader();
		((AbstractSchemaReader)reader).setFeatures(features);
		return reader;
	}

	/**
	 * Create a new instance of a SchemaWriter.
	 */
	public SchemaWriter newSchemaWriter()
	{
		SchemaWriter writer = new com.ebmwebsourcing.commons.schema.impl.SchemaWriter();
		return writer;
	}

}