/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import java.net.URI;
import java.util.Map;

import com.ebmwebsourcing.commons.schema.api.Import;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaReader.FeatureConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractImport<E> extends AbstractInclude<E> implements Import  {

	/**
	 * Default constructor
	 * @param model the model
	 * @param parent the parent description
	 */
	public AbstractImport(URI baseURI, E model, Map<FeatureConstants, Object> features) {
		super(baseURI, model, features);
	}
	
	
	/**
	 * Default constructor
	 * @param impt the model
	 * @param parent the parent description
	 */
	public AbstractImport(E model, Schema parent) {
		super(model, parent);
	}
	
	
}
