/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import com.ebmwebsourcing.commons.schema.api.Documentation;
import com.ebmwebsourcing.commons.schema.api.SchemaElement;



/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractSchemaElement<E> implements SchemaElement
{
	/**
	 * the model
	 */
	protected E model;

	protected Documentation documentation;

	/**
	 * Set the documentation for this document.
	 *
	 * @param docEl the documentation element
	 */
	public void setDocumentation(Documentation doc)	{
		this.documentation = doc;

		/*
		if(this.model instanceof org.w3._2001.xmlschema.Documentation) {
			((TDocumented)this.model).setDocumentation((TDocumentation) ((com.ebmwebsourcing.commons.wsdl.impl.wsdl11.Documentation)this.documentation).getModel());
		} else if(this.model instanceof List) {
			((List<DocumentedType>)this.model).add((org.w3._2001.xmlschema.Documentation) ((com.ebmwebsourcing.commons.wsdl.impl.Documentation)this.documentation).getModel());
		}
		 */
	}

	/**
	 * Get the documentation.
	 *
	 * @return the documentation element
	 */
	public Documentation getDocumentation()	{
		return documentation;
	}


	/**
	 * Create the documentation element.
	 *
	 * @return the documentation element
	 */
	public Documentation createDocumentation() {
		Documentation doc = null;
	/*	if(this.getClass().getPackage().getName().equals(Constants.WSDL11_PACKAGE)) {
			doc = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.Documentation();
		} else if(this.getClass().getPackage().getName().equals(Constants.WSDL20_PACKAGE)) {
			doc = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.Documentation();
		}
		*/
		return doc;
	}



	public E getModel() {
		return this.model;
	}

}
