/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import java.net.URI;
import java.util.Map;

import com.ebmwebsourcing.commons.schema.api.SchemaReader.FeatureConstants;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractInclude;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class Include extends AbstractInclude<org.w3._2001.xmlschema.Include> implements
		com.ebmwebsourcing.commons.schema.api.Include {
	
	public Include(URI baseURI, org.w3._2001.xmlschema.Include incl, Map<FeatureConstants, Object> features) {
		super(baseURI, incl, features);
		
		// get the documentation
		//this.documentation = new com.ebmwebsourcing.commons.schema.impl.Documentation(this.model.getDocumentation());
	}
	
	public Include(org.w3._2001.xmlschema.Include incl, Schema parent) {
		super(incl, parent);
		
		// get the documentation
		// this.documentation = new com.ebmwebsourcing.commons.schema.impl.Documentation(this.model.getDocumentation());
	}

	public String getLocationURI() {
		return this.model.getSchemaLocation();
	}

	public void setLocationURI(String locationURI) {
		this.model.setSchemaLocation(locationURI);
	}

}
