/**
 * easySchema - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.commons.schema.impl;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.SchemaFactory;

import com.ebmwebsourcing.commons.schema.api.SchemaException;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class SchemaJAXBContext {

	/**
	 * The JAXB context
	 */
	protected static JAXBContext jaxbContext;


	/**
	 * Private object initializations
	 */
	protected static void createContext() throws SchemaException {
		SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

		// The EndpointReference schema resource is in the Jar where the class is
		// loaded
		try {
			jaxbContext = JAXBContext.newInstance(new Class[] {
					org.w3._2001.xmlschema.ObjectFactory.class
			});
			
		} catch (JAXBException e) {
			throw new SchemaException(e);
		}


	}


	public static JAXBContext getJaxbContext() {
		return jaxbContext;
	}
}
