/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.schema;

import com.ebmwebsourcing.commons.schema.SchemaFactoryImpl;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.SchemaReader;
import com.ebmwebsourcing.commons.schema.api.SchemaWriter;
import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.impl.SchemaJAXBContext;
import com.ebmwebsourcing.commons.schema.impl.SchemaReader;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaFactory {
    private static Schema defaultSchema;
    private static Logger log;

    public static SchemaFactory newInstance() throws SchemaException {
        return new SchemaFactoryImpl();
    }

    public abstract Schema newSchema();

    public abstract com.ebmwebsourcing.commons.schema.api.SchemaReader newSchemaReader();

    public abstract com.ebmwebsourcing.commons.schema.api.SchemaReader newSchemaReader(Map<SchemaReader.FeatureConstants, Object> var1);

    public abstract SchemaWriter newSchemaWriter();

    public static Schema getDefaultSchema() {
        return defaultSchema;
    }

    static {
        log = Logger.getLogger(SchemaFactory.class.getName());
        URL schemaUrl4DOM = SchemaJAXBContext.class.getResource("/schema/XMLSchema4DOM.xsd");
        URL schemaUrl = SchemaJAXBContext.class.getResource("/schema/XMLSchema.xsd");
        try {
            DOMSource source = SourceHelper.convertInputSource2DOMSource(new InputSource(schemaUrl4DOM.openStream()));
            defaultSchema = new SchemaReader().readSchema(schemaUrl.toURI(), source);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warning("Error to read default schema => " + e.getMessage());
        }
        catch (XmlException e) {
            e.printStackTrace();
            log.warning("Error to read default schema => " + e.getMessage());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            log.warning("Error to read default schema => " + e.getMessage());
        }
    }
}

