/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.schema.api.abstractElmt;

import com.ebmwebsourcing.commons.schema.api.Attribute;
import com.ebmwebsourcing.commons.schema.api.ComplexType;
import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.SimpleType;
import com.ebmwebsourcing.commons.schema.api.Type;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractAttribute;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchemaElement;
import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractType;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Namespace;
import org.w3._2001.xmlschema.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElement<E>
extends AbstractSchemaElement<E>
implements Element {
    protected Schema schema;
    protected Type type;
    protected Element referencedElement;

    public AbstractElement(E model, Schema schema) {
        this.model = model;
        this.schema = schema;
        this.referencedElement = null;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String printXml(Object value) throws SchemaException {
        String res = null;
        if (this.type != null) {
            if (this.type instanceof SimpleType) {
                res = ((AbstractType)this.type).printXml(this, (String)value);
            } else if (this.type instanceof ComplexType) {
                ArrayList<String> newValue = new ArrayList<String>();
                if (value instanceof String) {
                    newValue.add((String)value);
                } else if (value instanceof List) {
                    newValue.addAll((List)value);
                }
                res = ((AbstractType)this.type).printXml(this, newValue);
            }
        }
        return res;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public org.jdom.Element generateElement(Object values) throws SchemaException {
        org.jdom.Element eOut = new org.jdom.Element(this.getQName().getLocalPart());
        eOut.setNamespace(Namespace.getNamespace((String)this.getQName().getPrefix(), (String)this.getQName().getNamespaceURI()));
        if (this.getType() != null) {
            String type = null;
            if (this.getType().getQName() != null) {
                if (this.getSchema().getAllNamespaces().getPrefix(this.getType().getQName().getNamespaceURI()) != null) {
                    type = this.getSchema().getAllNamespaces().getPrefix(this.getType().getQName().getNamespaceURI()) + ":" + this.getType().getQName().getLocalPart();
                    eOut.setAttribute("type", type);
                } else {
                    type = this.getType().getQName().getLocalPart();
                    eOut.setAttribute("type", type);
                }
            }
        }
        if (this.getType() instanceof ComplexType) {
            if ((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)this.getType()).getModel() != null) {
                List<Group.ParticleItem> items = null;
                if (((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)this.getType()).getModel()).getSequence() != null) {
                    items = ((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)this.getType()).getModel()).getSequence().getParticleItems();
                } else if (((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)this.getType()).getModel()).getAll() != null) {
                    items = ((org.w3._2001.xmlschema.ComplexType)((com.ebmwebsourcing.commons.schema.impl.ComplexType)this.getType()).getModel()).getAll().getParticleItems();
                }
                if (items != null) {
                    for (Group.ParticleItem item : items) {
                        Element e;
                        if (item.getItemElement() == null) continue;
                        if (item.getItemElement().getRef() == null) {
                            e = new com.ebmwebsourcing.commons.schema.impl.Element(item.getItemElement(), this.getSchema());
                            eOut.addContent(((AbstractElement)e).generateElement(this.nextValue(values)));
                            continue;
                        }
                        e = this.getSchema().getElement(item.getItemElement().getRef());
                        eOut.addContent(((AbstractElement)e).generateElement(this.nextValue(values)));
                    }
                }
                for (Attribute attr : ((ComplexType)this.getType()).getAttributes()) {
                    org.jdom.Attribute a = ((AbstractAttribute)attr).generateAttribute(this, this.nextValue(values));
                    eOut.setAttribute(a);
                }
            }
        } else {
            String val = this.nextValue(values);
            if (val != null) {
                eOut.setText(val);
            }
        }
        return eOut;
    }

    private String nextValue(Object values) {
        String res = null;
        if (values instanceof List) {
            res = (String)((List)values).get(0);
        } else if (values instanceof String) {
            res = (String)values;
        }
        return res;
    }

    public String toString() {
        return this.getQName().toString();
    }
}

