/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl;

import java.util.Map;

import org.apache.commons.lang.NotImplementedException;

import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader;
import com.ebmwebsourcing.commons.wsdl.api.WSDLWriter;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader.FeatureConstants;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;

/**
 * This class is a concrete implementation of the abstract class WSDLFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDLFactoryImpl extends WSDLFactory {
    /**
     * Create a new instance of a Definition, with an instance of a
     * PopulatedExtensionRegistry as its ExtensionRegistry.
     * 
     * @see com.ibm.wsdl.extensions.PopulatedExtensionRegistry
     */
    @Override
    public Description newDescription() {
        throw new NotImplementedException();
    }

    /**
     * Create a new instance of a WSDLReaderImpl.
     */
    @Override
    public WSDLReader newWSDLReader() {
        final WSDLReader reader = new com.ebmwebsourcing.commons.wsdl.impl.generic.WSDLReaderImpl();
        return reader;
    }

    /**
     * Create a new instance of a WSDLReaderImpl.
     */
    @Override
    public WSDLReader newWSDLReader(final Map<FeatureConstants, Object> features) {
        final WSDLReader reader = this.newWSDLReader();
        ((AbstractWSDLReaderImpl) reader).setFeatures(features);
        return reader;

    }

    /**
     * Create a new instance of a WSDLWriterImpl.
     */
    @Override
    public WSDLWriter newWSDLWriter() {
        final WSDLWriter writer = new com.ebmwebsourcing.commons.wsdl.impl.generic.WSDLWriterImpl();
        return writer;
    }

}
