/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

/**
 * This interface represents a port, an endpoint for the functionality described
 * by a particular port type.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface Endpoint extends WSDLElement {
    /**
     * Set the name of this port.
     * 
     * @param name
     *            the desired name
     */
    void setName(String name);

    /**
     * Get the name of this port.
     * 
     * @return the port name
     */
    String getName();

    /**
     * Set the address of this port.
     * 
     * @param address
     *            the desired name
     */
    void setAddress(String address);

    /**
     * Get the address of this port.
     * 
     * @return the port address
     */
    String getAddress();

    /**
     * Set the binding this port should refer to.
     * 
     * @param binding
     *            the desired binding
     */
    void setBinding(Binding binding);

    /**
     * Get the binding this port refers to.
     * 
     * @return the binding associated with this port
     */
    Binding getBinding();

    /*
     * http binding attribute
     */
    String getHttpAuthenticationScheme();

    String getHttpAuthenticationRealm();
}
