/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.commons.wsdl.util.Constants.MEPPatternConstants;

/**
 * This interface represents a WSDL operation. It includes information on input,
 * output and fault messages associated with usage of the operation.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface Operation extends WSDLElement {
    /**
     * Set the name of this operation.
     * 
     * @param name
     *            the desired name
     */
    void setQName(QName name);

    /**
     * Get the name of this operation.
     * 
     * @return the operation name
     */
    QName getQName();

    /**
     * Set the input message specification for this operation.
     * 
     * @param input
     *            the new input message
     */
    void setInput(Input input);

    /**
     * Get the input message specification for this operation.
     * 
     * @return the input message
     */
    Input getInput();

    /**
     * Set the output message specification for this operation.
     * 
     * @param output
     *            the new output message
     */
    void setOutput(Output output);

    /**
     * Get the output message specification for this operation.
     * 
     * @return the output message specification for the operation
     */
    Output getOutput();

    /**
     * Add a fault message that must be associated with this operation.
     * 
     * @param fault
     *            the new fault message
     */
    void addFault(Fault fault);

    /**
     * Get the specified fault .
     * 
     * @param name
     *            the name of the desired fault message.
     * @return the corresponding fault message, or null if there wasn't any
     *         matching message
     */
    Fault getFault(String name);

    /**
     * Get the specified fault .
     * 
     * @param name
     *            the name of the fault element.
     * @return the corresponding fault message, or null if there wasn't any
     *         matching message
     */
    Fault getFaultByElementName(QName name);

    /**
     * Remove the specified fault message.
     * 
     * @param name
     *            the name of the fault message to be removed.
     * @return the fault message which was removed
     */
    Fault removeFault(String name);

    /**
     * Remove the specified fault .
     * 
     * @param name
     *            the name of the fault element to be removed.
     * @return the fault message which was removed
     */
    Fault removeFaultByElementName(QName name);

    /**
     * Get all the fault messages associated with this operation.
     * 
     * @return names of fault messages
     */
    List<Fault> getFaults();

    /**
     * Set the parameter ordering for a request-response, or solicit-response
     * operation.
     * 
     * @param parameterOrder
     *            a list of named parameters containing the part names to
     *            reflect the desired order of parameters for RPC-style
     *            operations
     * @throws WSDLException
     */
    void setParameterOrdering(List<String> parameterOrder) throws WSDLException;

    /**
     * Get the parameter ordering for this operation.
     * 
     * @return the parameter ordering, a list consisting of message part names
     */
    List<String> getParameterOrdering();

    /**
     * get the pattern
     */
    MEPPatternConstants getPattern();

    /**
     * set the pattern
     * 
     * @param pattern
     *            the pattern
     * @throws WSDLException
     */
    void setPattern(MEPPatternConstants pattern) throws WSDLException;

    /**
     * get signature of the operation
     * 
     * @return the signature
     */
    String getSignature();

}
