/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

/**
 * This interface represents all WSDL Elements
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface WSDLElement extends Serializable {
    /**
     * Set the documentation element for this document.
     * 
     * @param docEl
     *            the documentation element
     */
    void setDocumentation(Documentation doc);

    /**
     * Get the documentation element.
     * 
     * @return the documentation element
     */
    Documentation getDocumentation();

    /**
     * Create the documentation element.
     * 
     * @return the documentation element
     */
    Documentation createDocumentation();
    
    /**
     * Get all the cloned elements defined here.
     * @throws WSDLException 
     */
    List<Element> getOtherElements() throws WSDLException;
    
    /**
     * Get the map containing all the attributes defined on this
     * element. The keys are the qnames of the attributes.
     * 
     * @return a map containing all the attributes defined on this
     *         element
     * @throws WSDLException 
     * 
     */
    Map<QName, String> getOtherAttributes() throws WSDLException;
}
