/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api;

/**
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 * 
 */
public class WSDLException extends Exception {
    public static final long serialVersionUID = 1;

    public static final String INVALID_WSDL = "INVALID_WSDL";

    public static final String PARSER_ERROR = "PARSER_ERROR";

    public static final String OTHER_ERROR = "OTHER_ERROR";

    public static final String CONFIGURATION_ERROR = "CONFIGURATION_ERROR";

    public static final String UNBOUND_PREFIX = "UNBOUND_PREFIX";

    public static final String NO_PREFIX_SPECIFIED = "NO_PREFIX_SPECIFIED";

    private String faultCode = null;

    private Throwable targetThrowable = null;

    private String location = null;

    public WSDLException(final String faultCode, final String msg, final Throwable t) {
        super(msg, t);
        this.setFaultCode(faultCode);
    }

    public WSDLException(final String msg, final Throwable t) {
        super(msg, t);
    }

    public WSDLException(final Throwable t) {
        super(t);
    }

    public WSDLException(final String msg) {
        super(msg);
    }

    public WSDLException(final String faultCode, final String msg) {
        this(faultCode, msg, null);
    }

    public void setFaultCode(final String faultCode) {
        this.faultCode = faultCode;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setTargetException(final Throwable targetThrowable) {
        this.targetThrowable = targetThrowable;
    }

    public Throwable getTargetException() {
        if (this.targetThrowable == null) {
            return this.getCause();
        } else {
            return this.targetThrowable;
        }
    }

    /**
     * Set the location using an XPath expression. Used for error messages.
     * 
     * @param location
     *            an XPath expression describing the location where the
     *            exception occurred.
     */
    public void setLocation(final String location) {
        this.location = location;
    }

    /**
     * Get the location, if one was set. Should be an XPath expression which is
     * used for error messages.
     */
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getMessage() {
        final StringBuffer strBuf = new StringBuffer();

        strBuf.append("WSDLException");

        if (this.location != null) {
            try {
                strBuf.append(" (at " + this.location + ")");
            } catch (final IllegalArgumentException e) {
            }
        }

        if (this.faultCode != null) {
            strBuf.append(": faultCode=" + this.faultCode);
        }

        final String thisMsg = super.getMessage();
        String targetMsg = null;
        String targetName = null;
        if (this.getTargetException() != null) {
            targetMsg = this.getTargetException().getMessage();
            targetName = this.getTargetException().getClass().getName();
        }

        if ((thisMsg != null) && ((targetMsg == null) || !thisMsg.equals(targetMsg))) {
            strBuf.append(": " + thisMsg);
        }

        if (targetName != null) {
            strBuf.append(": " + targetName);
        }

        if (targetMsg != null) {
            strBuf.append(": " + targetMsg);
        }

        return strBuf.toString();
    }
}
