/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.commons.wsdl.api.Binding;
import com.ebmwebsourcing.commons.wsdl.api.BindingFault;
import com.ebmwebsourcing.commons.wsdl.api.BindingInput;
import com.ebmwebsourcing.commons.wsdl.api.BindingOperation;
import com.ebmwebsourcing.commons.wsdl.api.BindingOutput;
import com.ebmwebsourcing.commons.wsdl.api.Operation;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractBindingOperationImpl<E> extends AbstractWSDLElementImpl<E> implements
        BindingOperation {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the parent binding
     */
    protected Binding binding;

    /**
     * the input
     */
    protected BindingInput input;

    /**
     * the output
     */
    protected BindingOutput output;

    /**
     * the faults
     */
    protected List<BindingFault> faults = new ArrayList<BindingFault>();

    /**
     * @return the binding
     */
    public Binding getBinding() {
        return this.binding;
    }

    public Operation getOperation() {
        return this.binding.getInterface().getOperation(this.getQName());
    }

    /**
     * @return the input
     */
    public BindingInput getInput() {
        return this.input;
    }

    /**
     * @param input
     *            the input to set
     */
    public void setInput(final BindingInput input) {
        this.input = input;
    }

    /**
     * @return the output
     */
    public BindingOutput getOutput() {
        return this.output;
    }

    /**
     * @param output
     *            the output to set
     */
    public void setOutput(final BindingOutput output) {
        this.output = output;
    }

    /**
     * @return the fault
     */
    public List<BindingFault> getFaults() {
        if (this.faults == null) {
            this.faults = new ArrayList<BindingFault>();
        }
        return this.faults;
    }

    /**
     * @param fault
     *            the fault to set
     */
    public void setFaults(final List<BindingFault> fault) {
        this.faults = fault;
    }

    public BindingFault getFault(final String name) {
        BindingFault res = null;
        for (final BindingFault f : this.faults) {
            if (f.getName().equals(name)) {
                res = f;
                break;
            }
        }
        return res;
    }

}
