/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBElement;

import org.jvnet.hyperjaxb3.item.Item;
import org.xmlsoap.schemas.wsdl.mime.ContentType;
import org.xmlsoap.schemas.wsdl.mime.MultipartRelatedType;
import org.xmlsoap.schemas.wsdl.mime.TMimeXml;

import com.ebmwebsourcing.commons.wsdl.api.BindingInput;
import com.ebmwebsourcing.commons.wsdl.api.BindingOperation;
import com.ebmwebsourcing.commons.wsdl.api.BindingOutput;
import com.ebmwebsourcing.commons.wsdl.api.BindingParam;
import com.ebmwebsourcing.commons.wsdl.api.Fault;
import com.ebmwebsourcing.commons.wsdl.api.binding.BindingProtocol;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.http.HTTPBinding4Wsdl11;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEBinding4Wsdl11;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Binding4Wsdl11;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Binding4Wsdl11;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl20.http.HTTPBinding4Wsdl20;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl20.soap.SOAPBinding4Wsdl20;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractBindingParamImpl<E> extends AbstractWSDLElementImpl<E> implements
        BindingParam {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the parent operation
     */
    protected BindingOperation bindingOperation;

    /**
     * the input
     */
    protected BindingInput input;

    /**
     * the output
     */
    protected BindingOutput output;

    /**
     * the faults
     */
    protected List<Fault> faults = new ArrayList<Fault>();

    /**
     * the binding protocol
     */
    protected BindingProtocol bindingProtocol;

    /**
     * @return the binding
     */
    public BindingOperation getBindingOperation() {
        return this.bindingOperation;
    }

    @SuppressWarnings("unchecked")
    public static BindingProtocol extractBindingProtocol(final List<Item<Object>> items,
            final AbstractBindingParamImpl param) {
        BindingProtocol bindingProtocol = null;
        // get the binding protocol
        org.xmlsoap.schemas.wsdl.http.UrlEncoded encoded = null;
        org.xmlsoap.schemas.wsdl.http.UrlReplacement replacement = null;

        final List<ContentType> contents = new ArrayList<ContentType>();
        final List<TMimeXml> mimeXmls = new ArrayList<TMimeXml>();
        final List<MultipartRelatedType> multiparts = new ArrayList<MultipartRelatedType>();

        org.xmlsoap.schemas.wsdl.soap.TBody soap11body = null;
        final List<org.xmlsoap.schemas.wsdl.soap.THeader> soap11headers = new ArrayList<org.xmlsoap.schemas.wsdl.soap.THeader>();
        org.xmlsoap.schemas.wsdl.soap.TFault soap11fault = null;

        org.xmlsoap.schemas.wsdl.soap12.TBody soap12body = null;
        final List<org.xmlsoap.schemas.wsdl.soap12.THeader> soap12headers = new ArrayList<org.xmlsoap.schemas.wsdl.soap12.THeader>();
        org.xmlsoap.schemas.wsdl.soap12.TFault soap12fault = null;

        final List<org.w3.ns.wsdl.http.Header> httpHeaders = new ArrayList<org.w3.ns.wsdl.http.Header>();
        final List<org.w3.ns.wsdl.soap.Header> soapHeaders = new ArrayList<org.w3.ns.wsdl.soap.Header>();
        final List<org.w3.ns.wsdl.soap.Module> soapModules = new ArrayList<org.w3.ns.wsdl.soap.Module>();

        Object value = null;
        for (final Item<Object> item : items) {
            if (item.getItem() instanceof JAXBElement) {
                value = ((JAXBElement) item.getItem()).getValue();
            } else {
                value = item.getItem();
            }
            if (value instanceof org.xmlsoap.schemas.wsdl.http.UrlEncoded) {
                encoded = (org.xmlsoap.schemas.wsdl.http.UrlEncoded) value;
            } else if (value instanceof org.xmlsoap.schemas.wsdl.http.UrlReplacement) {
                replacement = (org.xmlsoap.schemas.wsdl.http.UrlReplacement) value;
            } else if (value instanceof org.xmlsoap.schemas.wsdl.mime.ContentType) {
                contents.add((org.xmlsoap.schemas.wsdl.mime.ContentType) value);
            } else if (value instanceof org.xmlsoap.schemas.wsdl.mime.TMimeXml) {
                mimeXmls.add((org.xmlsoap.schemas.wsdl.mime.TMimeXml) value);
            } else if (value instanceof org.xmlsoap.schemas.wsdl.mime.MultipartRelatedType) {
                multiparts.add((org.xmlsoap.schemas.wsdl.mime.MultipartRelatedType) value);
            } else if (value instanceof org.xmlsoap.schemas.wsdl.soap.TFault) {
                soap11fault = (org.xmlsoap.schemas.wsdl.soap.TFault) value;
            } else if (value instanceof org.xmlsoap.schemas.wsdl.soap12.TFault) {
                soap12fault = (org.xmlsoap.schemas.wsdl.soap12.TFault) value;
            } else if (value instanceof org.xmlsoap.schemas.wsdl.soap.TBody) {
                soap11body = (org.xmlsoap.schemas.wsdl.soap.TBody) value;
            } else if (value instanceof org.xmlsoap.schemas.wsdl.soap12.TBody) {
                soap12body = (org.xmlsoap.schemas.wsdl.soap12.TBody) value;
            } else if (value instanceof org.xmlsoap.schemas.wsdl.soap.THeader) {
                soap11headers.add((org.xmlsoap.schemas.wsdl.soap.THeader) value);
            } else if (value instanceof org.xmlsoap.schemas.wsdl.soap12.THeader) {
                soap12headers.add((org.xmlsoap.schemas.wsdl.soap12.THeader) value);
            } else if (value instanceof org.w3.ns.wsdl.http.Header) {
                httpHeaders.add((org.w3.ns.wsdl.http.Header) value);
            } else if (value instanceof org.w3.ns.wsdl.soap.Header) {
                soapHeaders.add((org.w3.ns.wsdl.soap.Header) value);
            } else if (value instanceof org.w3.ns.wsdl.soap.Module) {
                soapModules.add((org.w3.ns.wsdl.soap.Module) value);
            }

        }

        /**
         * WSDL 1.1
         */
        // contains http binding
        if ((encoded != null) || (replacement != null)) {
            bindingProtocol = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.http.HTTPBindingImpl(
                    encoded, replacement);
        }

        // contain mime binding
        if ((contents.size() > 0) || (mimeXmls.size() > 0) || (multiparts.size() > 0)) {
            bindingProtocol = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.mime.MIMEBindingImpl(
                    contents, mimeXmls, multiparts, param);
        }

        // contain soap 1.1 binding
        if ((soap11body != null) || (soap11headers.size() > 0) || (soap11fault != null)) {
            bindingProtocol = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap11.SOAP11BindingImpl(
                    soap11headers, soap11body, soap11fault);
        }

        // contain soap 1.2 binding
        if ((soap12body != null) || (soap12headers.size() > 0) || (soap12fault != null)) {
            bindingProtocol = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap12.SOAP12BindingImpl(
                    soap12headers, soap12body, soap12fault);
        }

        /**
         * WSDL 2.0
         */
        // contains http binding
        if (httpHeaders.size() > 0) {
            bindingProtocol = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.binding.http.HTTPBindingImpl(
                    httpHeaders);
        }

        // contains soap binding
        if ((soapHeaders.size() > 0) || (soapModules.size() > 0)) {
            bindingProtocol = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.binding.soap.SOAPBindingImpl(
                    soapHeaders, soapModules);
        }

        return bindingProtocol;
    }

    public HTTPBinding4Wsdl11 getHTTPBinding4Wsdl11() {
        HTTPBinding4Wsdl11 res = null;
        if (this.bindingProtocol instanceof HTTPBinding4Wsdl11) {
            res = (HTTPBinding4Wsdl11) this.bindingProtocol;
        }
        return res;
    }

    public MIMEBinding4Wsdl11 getMIMEBinding4Wsdl11() {
        MIMEBinding4Wsdl11 res = null;
        if (this.bindingProtocol instanceof MIMEBinding4Wsdl11) {
            res = (MIMEBinding4Wsdl11) this.bindingProtocol;
        }
        return res;
    }

    public SOAP11Binding4Wsdl11 getSOAP11Binding4Wsdl11() {
        SOAP11Binding4Wsdl11 res = null;
        if (this.bindingProtocol instanceof SOAP11Binding4Wsdl11) {
            res = (SOAP11Binding4Wsdl11) this.bindingProtocol;
        }
        return res;
    }

    public SOAP12Binding4Wsdl11 getSOAP12Binding4Wsdl11() {
        SOAP12Binding4Wsdl11 res = null;
        if (this.bindingProtocol instanceof SOAP12Binding4Wsdl11) {
            res = (SOAP12Binding4Wsdl11) this.bindingProtocol;
        }
        return res;
    }

    public HTTPBinding4Wsdl20 getHTTPBinding4Wsdl20() {
        HTTPBinding4Wsdl20 res = null;
        if (this.bindingProtocol instanceof HTTPBinding4Wsdl20) {
            res = (HTTPBinding4Wsdl20) this.bindingProtocol;
        }
        return res;
    }

    public SOAPBinding4Wsdl20 getSOAP12Binding4Wsdl20() {
        SOAPBinding4Wsdl20 res = null;
        if (this.bindingProtocol instanceof SOAPBinding4Wsdl20) {
            res = (SOAPBinding4Wsdl20) this.bindingProtocol;
        }
        return res;
    }
}
