/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.schema.api.Schema;
import com.ebmwebsourcing.commons.wsdl.api.Operation;
import com.ebmwebsourcing.commons.wsdl.api.Param;
import com.ebmwebsourcing.commons.wsdl.api.Types;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractParamImpl<E> extends AbstractWSDLElementImpl<E> implements Param {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the parent operation
     */
    protected Operation operation;

    /**
     * the element name
     */
    protected QName elementName;

    /**
     * @return the interface
     */
    public Operation getOperation() {
        return this.operation;
    }

    @SuppressWarnings("unchecked")
    public Element getElement() {
        Element res = null;
        final Types types = ((AbstractInterfaceTypeImpl) ((AbstractOperationImpl) this.operation)
                .getInterface()).getDescription().getTypes();
        if (this.elementName != null) {
            for (final Schema schema : types.getSchemas()) {
                res = schema.getElement(this.elementName);
                if (res != null) {
                    break;
                }
            }
        }
        return res;
    }

}
