/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.generic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

import javax.xml.transform.dom.DOMSource;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import com.ebmwebsourcing.commons.wsdl.util.WSDLJDomAnalyzer;
import com.ebmwebsourcing.commons.wsdl.util.Constants.WSDLVersionConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDLReaderImpl extends AbstractWSDLReaderImpl implements
        com.ebmwebsourcing.commons.wsdl.api.WSDLReader {

    public Description readWSDL(final URI wsdlURI) throws WSDLException {
        Description desc = null;
        try {

            InputStream source = null;
            final File f = new File(wsdlURI.getPath());
            if (f.exists()) {
                source = new FileInputStream(f);
            } else {
                source = wsdlURI.toURL().openStream();
            }

            desc = this.readWSDL(wsdlURI, SourceHelper
                    .convertInputSource2DOMSource(new InputSource(source)));
        } catch (final MalformedURLException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        } catch (final IOException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        } catch (final WSDLException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        } catch (final XmlException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        return desc;

    }

    private com.ebmwebsourcing.commons.wsdl.api.WSDLReader getConcreteReader(final DOMSource input)
            throws WSDLException {
        com.ebmwebsourcing.commons.wsdl.api.WSDLReader reader = null;
        try {
            // analyze wsdl
            this.analyzer = new WSDLJDomAnalyzer(SourceHelper.convertDOMSource2InputSource(input));

            final WSDLVersionConstants version = this.analyzer.getVersion();

            if (version == WSDLVersionConstants.WSDL11) {
                reader = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.WSDLReaderImpl();
            } else if (version == WSDLVersionConstants.WSDL20) {
                reader = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.WSDLReaderImpl();

            } else {
                throw new WSDLException("unknown version of wsdl");
            }
            ((AbstractWSDLReaderImpl) reader).setFeatures(this.getFeatures());
        } catch (final JDOMException e) {
            throw new WSDLException("unknown version of wsdl", e);
        } catch (final XmlException e) {
            throw new WSDLException("unknown version of wsdl", e);
        }
        return reader;
    }

    public Description readWSDL(final Document wsdlDocument) throws WSDLException {
        Description desc = null;
        final DOMSource domSource = new DOMSource(wsdlDocument);
        try {
            if (wsdlDocument.getDocumentURI() == null) {
                throw new WSDLException("document uri cannot be null");
            }
            desc = this.readWSDL(new URI(wsdlDocument.getDocumentURI()), domSource);
        } catch (final URISyntaxException e) {
            throw new WSDLException(e);
        }
        return desc;
    }

    public Description readWSDL(final URI wsdlURI, final DOMSource inputSource) throws WSDLException {
        Description desc = null;
        try {

            final DOMSource source1 = SourceHelper.cloneSource(inputSource);
            final DOMSource source2 = SourceHelper.cloneSource(inputSource);

            // analyze wsdl
            final com.ebmwebsourcing.commons.wsdl.api.WSDLReader reader = this.getConcreteReader(source1);
            ((AbstractWSDLReaderImpl) reader).setAnalyzer(this.analyzer);

            desc = reader.readWSDL(wsdlURI, source2);

        } catch (final XmlException e) {
            throw new WSDLException(e);
        }
        return desc;
    }

}
