/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.TBindingOperation;
import org.xmlsoap.schemas.wsdl.TBindingOperationFault;

import com.ebmwebsourcing.commons.wsdl.api.BindingFault;
import com.ebmwebsourcing.commons.wsdl.api.Operation;
import com.ebmwebsourcing.commons.wsdl.api.Binding.StyleConstant;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractBindingImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractBindingOperationImpl;
import com.ebmwebsourcing.commons.wsdl.util.Constants.SOAPMEPConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BindingOperationImpl extends AbstractBindingOperationImpl<TBindingOperation> implements
        com.ebmwebsourcing.commons.wsdl.api.BindingOperation {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public BindingOperationImpl(final TBindingOperation bindingOperation, final BindingImpl bindingImpl) {
        this.model = bindingOperation;
        this.binding = bindingImpl;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl(
                this.model.getDocumentation());

        // get input binding
        if (this.model.getInput() != null) {
            this.input = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.BindingInputImpl(
                    this.model.getInput(), this);
        }

        // get output binding
        if (this.model.getOutput() != null) {
            this.output = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.BindingOutputImpl(
                    this.model.getOutput(), this);
        }
        // get faults bindings
        if (this.model.getFault() != null) {
            for (final TBindingOperationFault fault : this.model.getFault()) {
                this.faults.add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.BindingFaultImpl(
                        fault, this));
            }
        }
    }

    public void addFault(final BindingFault bindingFault) {
        throw new NotImplementedException();
    }

    public BindingFault removeFault(final String name) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        throw new NotImplementedException();
    }

    public void setOperation(final Operation operation) {
        throw new NotImplementedException();
    }

    public void addBindingOperation(
            final com.ebmwebsourcing.commons.wsdl.api.BindingOperation bindingOperation) {
        throw new NotImplementedException();
    }

    @SuppressWarnings("unchecked")
    public StyleConstant getStyle() {
        StyleConstant style = null;
        for (final Object element : this.model.getAny()) {
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap.TOperation) {
                if (((org.xmlsoap.schemas.wsdl.soap.TOperation) ((JAXBElement) element).getValue())
                        .getStyle() != null) {
                    style = StyleConstant
                            .valueOf(((org.xmlsoap.schemas.wsdl.soap.TOperation) ((JAXBElement) element)
                                    .getValue()).getStyle().value().toUpperCase());
                }
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap12.TOperation) {
                if (((org.xmlsoap.schemas.wsdl.soap12.TOperation) ((JAXBElement) element).getValue())
                        .getStyle() != null) {
                    style = StyleConstant
                            .valueOf(((org.xmlsoap.schemas.wsdl.soap12.TOperation) ((JAXBElement) element)
                                    .getValue()).getStyle().value().toUpperCase());
                }
                break;
            }
        }
        if (style == null) {
            style = this.binding.getStyle();
        }

        return style;
    }

    @SuppressWarnings("unchecked")
    public QName getQName() {
        return new QName(
                ((AbstractBindingImpl) this.binding).getDescription().getTargetNamespace(),
                this.model.getName());
    }

    public com.ebmwebsourcing.commons.wsdl.api.BindingOperation removeBindingOperation(final String name,
            final String inputName, final String outputName) {
        throw new NotImplementedException();
    }

    public SOAPMEPConstants getMEP() {
        SOAPMEPConstants mep = null;
        if ((this.getModel().getInput() != null) && (this.getModel().getOutput() != null)) {
            mep = SOAPMEPConstants.REQUEST_RESPONSE;
        } else if (this.getModel().getInput() != null) {
            mep = SOAPMEPConstants.ONE_WAY;
        }
        return mep;
    }

    public void setMEP(final SOAPMEPConstants mep) {
        throw new NotImplementedException();
    }

    @SuppressWarnings("unchecked")
    public String getHttpLocation() {
        String httpLocation = null;
        for (final Object element : this.model.getAny()) {
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.http.OperationType) {
                httpLocation = ((org.xmlsoap.schemas.wsdl.http.OperationType) ((JAXBElement) element)
                        .getValue()).getLocation();
                break;
            }
        }
        return httpLocation;
    }

    @SuppressWarnings("unchecked")
    public String getSoapAction() {
        String soapAction = null;
        for (final Object element : this.model.getAny()) {
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap.TOperation) {
                soapAction = ((org.xmlsoap.schemas.wsdl.soap.TOperation) ((JAXBElement) element)
                        .getValue()).getSoapAction();
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap12.TOperation) {
                soapAction = ((org.xmlsoap.schemas.wsdl.soap12.TOperation) ((JAXBElement) element)
                        .getValue()).getSoapAction();
                break;
            }
        }

        return soapAction;
    }

    public String getHttpContentEncodingDefault() {
        return null;
    }

    public String getHttpFaultSerialization() {
        return null;
    }

    public String getHttpInputSerialization() {
        return null;
    }

    public String getHttpMethod() {
        return this.getBinding().getTransportProtocol();
    }

    public String getHttpOutputSerialization() {
        return null;
    }

    public String getHttpQueryParameterSeparator() {
        return null;
    }

    public boolean isHttpIgnoreUncited() {
        return false;
    }

}
