/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import java.util.List;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.TBindingOperationMessage;

import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractBindingParamImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BindingOutputImpl extends AbstractBindingParamImpl<TBindingOperationMessage> implements
        com.ebmwebsourcing.commons.wsdl.api.BindingOutput {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    @SuppressWarnings("unchecked")
    public BindingOutputImpl(final TBindingOperationMessage param,
            final BindingOperationImpl bindingOperationImpl) {
        this.model = param;
        this.bindingOperation = bindingOperationImpl;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl(
                this.model.getDocumentation());

        // get the binding protocol
        this.bindingProtocol = AbstractBindingParamImpl.extractBindingProtocol((List) this.model.getAnyItems(), this);
    }

    public String getName() {
        return this.model.getName();
    }

    public void setName(final String name) {
        throw new NotImplementedException();
    }

    public String getHttpContentEncoding() {
        return null;
    }
}
