/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.jdom.Document;
import org.xmlsoap.schemas.wsdl.TBinding;
import org.xmlsoap.schemas.wsdl.TDefinitions;
import org.xmlsoap.schemas.wsdl.TDocumented;
import org.xmlsoap.schemas.wsdl.TImport;
import org.xmlsoap.schemas.wsdl.TMessage;
import org.xmlsoap.schemas.wsdl.TPortType;
import org.xmlsoap.schemas.wsdl.TService;
import org.xmlsoap.schemas.wsdl.TTypes;

import com.ebmwebsourcing.commons.wsdl.api.Binding;
import com.ebmwebsourcing.commons.wsdl.api.BindingFault;
import com.ebmwebsourcing.commons.wsdl.api.BindingOperation;
import com.ebmwebsourcing.commons.wsdl.api.Endpoint;
import com.ebmwebsourcing.commons.wsdl.api.Fault;
import com.ebmwebsourcing.commons.wsdl.api.Import;
import com.ebmwebsourcing.commons.wsdl.api.Include;
import com.ebmwebsourcing.commons.wsdl.api.Input;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.Operation;
import com.ebmwebsourcing.commons.wsdl.api.Output;
import com.ebmwebsourcing.commons.wsdl.api.Part;
import com.ebmwebsourcing.commons.wsdl.api.Service;
import com.ebmwebsourcing.commons.wsdl.api.Types;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader.FeatureConstants;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractDescriptionImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import com.ebmwebsourcing.commons.wsdl.impl.wsdl20.Constants;
import com.ebmwebsourcing.commons.wsdl.util.Constants.WSDLVersionConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@SuppressWarnings("serial")
public class DescriptionImpl extends AbstractDescriptionImpl<TDefinitions> implements
        com.ebmwebsourcing.commons.wsdl.api.Description {

    /**
     * the list of messages
     */
    private List<TMessage> messages = new ArrayList<TMessage>();

    public DescriptionImpl(final URI baseURI, final TDefinitions definition, final Document document,
            final Map<FeatureConstants, Object> features) throws WSDLException {
        super(baseURI, definition, document, features);

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl(
                this.model.getDocumentation());

        for (final TDocumented part : this.model.getAnyTopLevelOptionalElement()) {
            // get imports
            if (part instanceof TImport) {
                final Import impt = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.ImportImpl(
                        (TImport) part, this);
                this.imports.add(impt);
            }

            // get services
            if (part instanceof TService) {
                final Service s = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.ServiceImpl(
                        (TService) part, this);
                this.services.add(s);
            }

            // get bindings
            if (part instanceof TBinding) {
                final Binding b = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.BindingImpl(
                        (TBinding) part, this);
                this.bindings.add(b);
            }

            // get interfaces
            if (part instanceof TPortType) {
                final InterfaceType itf = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.InterfaceTypeImpl(
                        (TPortType) part, this);
                this.interfaces.add(itf);
            }

            // get types
            if (part instanceof TTypes) {
                this.types = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.TypesImpl(
                        (TTypes) part, this);
            }

            // get messages
            if (part instanceof TMessage) {
                this.messages.add((TMessage) part);
            }
        }

        this.addImportElementsInAllList();
        for (final Import impt : this.imports) {
            if (impt.getDescription() != null) {
                this.messages.addAll(((DescriptionImpl) impt.getDescription()).getMessages());
            }
        }

        this.addIncludeElementsInAllList();
        for (final Include incl : this.includes) {
            if (incl.getDescription() != null) {
                this.messages.addAll(((DescriptionImpl) incl.getDescription()).getMessages());
            }
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addBinding(final Binding binding) {
        super.addBinding(binding);
        this.model.getAnyTopLevelOptionalElement().add(
                (TDocumented) ((AbstractWSDLElementImpl) binding).getModel());
    }

    public void addNamespace(final String prefix, final String namespaceURI) {
        throw new NotImplementedException();
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addInterface(final InterfaceType interfaceType) {
        super.addInterface(interfaceType);
        this.model.getAnyTopLevelOptionalElement().add(
                (TDocumented) ((AbstractWSDLElementImpl) interfaceType).getModel());
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addService(final Service service) {
        super.addService(service);
        this.model.getAnyTopLevelOptionalElement().add(
                (TDocumented) ((AbstractWSDLElementImpl) service).getModel());
    }

    public Binding createBinding() {
        throw new NotImplementedException();
    }

    public BindingFault createBindingFault() {
        throw new NotImplementedException();
    }

    public BindingOperation createBindingOperation() {
        throw new NotImplementedException();
    }

    public Fault createFault() {
        throw new NotImplementedException();
    }

    public Import createImport() {
        throw new NotImplementedException();
    }

    public Input createInput() {
        throw new NotImplementedException();
    }

    public Operation createOperation() {
        throw new NotImplementedException();
    }

    public Output createOutput() {
        throw new NotImplementedException();
    }

    public Part createPart() {
        throw new NotImplementedException();
    }

    public Endpoint createEndpoint() {
        throw new NotImplementedException();
    }

    public InterfaceType createInterface() {
        throw new NotImplementedException();
    }

    public Service createService() {
        return new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.ServiceImpl();
    }

    public Types createTypes() {
        throw new NotImplementedException();
    }

    public QName getQName() {
        QName res = null;
        if (this.model.getName() != null) {
            res = new QName(this.getTargetNamespace(), this.model.getName());
        }
        return res;
    }

    public String getTargetNamespace() {
        return this.model.getTargetNamespace();
    }

    public Binding removeBinding(final QName name) {
        throw new NotImplementedException();
    }

    public Import removeImport(final Import importDef) {
        throw new NotImplementedException();
    }

    public String removeNamespace(final String prefix) {
        throw new NotImplementedException();
    }

    public InterfaceType removeInterface(final QName name) {
        throw new NotImplementedException();
    }

    public Service removeService(final QName name) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        throw new NotImplementedException();
    }

    public void setTargetNamespace(final String targetNamespace) {
        throw new NotImplementedException();
    }

    @Override
    public void addInclude(final Include incl) throws WSDLException {
        throw new WSDLException(Constants.NOT_SUPPORTED);
    }

    public Include removeInclude(final Include includeDef) throws WSDLException {
        throw new WSDLException(Constants.NOT_SUPPORTED);
    }

    public WSDLVersionConstants getVersion() {
        return WSDLVersionConstants.WSDL11;
    }

    /**
     * @return the messages
     */
    public List<TMessage> getMessages() {
        return this.messages;
    }

    /**
     * @param messages
     *            the messages to set
     */
    public void setMessages(final List<TMessage> messages) {
        this.messages = messages;
    }

}
