/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import org.xmlsoap.schemas.wsdl.TDocumentation;

import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DocumentationImpl extends AbstractWSDLElementImpl<TDocumentation> implements
        com.ebmwebsourcing.commons.wsdl.api.Documentation {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public DocumentationImpl() {
        this.model = new TDocumentation();
    }

    public DocumentationImpl(final TDocumentation doc) {
        this.model = doc;
    }

    public String getContent() {
        final StringBuffer res = new StringBuffer();
        for (final TDocumentation.ContentItem item : this.model.getContentItems()) {
            res.append(item.getText());
        }
        return res.toString();
    }

    public void setContent(final String content) {
        this.model.getContentItems().clear();
        final TDocumentation.ContentItem contentItem = new TDocumentation.ContentItem();
        contentItem.setText(content);
        this.model.getContentItems().add(contentItem);
    }

}
