/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.TPart;

import com.ebmwebsourcing.commons.schema.api.Type;
import com.ebmwebsourcing.commons.wsdl.api.Param;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractOperationImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractParamImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractPartImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class PartImpl extends AbstractPartImpl<TPart> implements
        com.ebmwebsourcing.commons.wsdl.api.Part {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the part
     */
    private transient final TPart part;

    /**
     * 
     * @param part
     * @param elmt
     * @param param
     */
    public PartImpl(final TPart part, final Param param) {
        this.part = part;
        this.param = param;

        this.elementName = this.part.getElement();
        this.typeName = this.part.getType();
    }

    @SuppressWarnings("unchecked")
    public QName getPartQName() {
        return new QName(
                ((AbstractInterfaceTypeImpl) ((AbstractOperationImpl) ((AbstractParamImpl) this.param)
                        .getOperation()).getInterface()).getDescription().getTargetNamespace(),
                this.part.getName());
    }

    public void setPartQName(final QName name) {
        this.part.setName(name.getLocalPart());
    }

    public void setElement(final com.ebmwebsourcing.commons.schema.api.Element element) {
        throw new NotImplementedException();
    }

    public void setType(final Type type) {
        throw new NotImplementedException();
    }

}
