/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import java.io.StringWriter;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Document;
import org.xmlsoap.schemas.wsdl.TDefinitions;

import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDLWriterImpl implements com.ebmwebsourcing.commons.wsdl.api.WSDLWriter {

    /**
     * The JAXB unique marshaller.
     */
    private static Marshaller marshaller = null;

    /**
     * The exception raised during JAXB unique marshaller creation.
     */
    private static WSDLException marshallerCreationEx = null;

    /*
     * Private object initializations
     */
    static {
        try {
            WSDLJAXBContext.createContext();
            WSDLWriterImpl.marshaller = WSDLJAXBContext.getJaxbContext().createMarshaller();
            // marshaller.setSchema(schema);

        } catch (final JAXBException e) {
            final WSDLException schemaCreationEx = new WSDLException("Failed to get resources '"
                    + Constants.XSD_WSDL_11 + "'", e);

            WSDLWriterImpl.marshallerCreationEx = new WSDLException("Failed to create the JAXB marshaller",
                    schemaCreationEx);

        } catch (final WSDLException e) {
            final WSDLException schemaCreationEx = new WSDLException("Failed to get resources '"
                    + Constants.XSD_WSDL_11 + "'", e);

            WSDLWriterImpl.marshallerCreationEx = new WSDLException("Failed to create the JAXB marshaller",
                    schemaCreationEx);

        }
    }

    @SuppressWarnings("unchecked")
    private static Document convertWSDL11Definition2DOMElement(final TDefinitions wsdlDescriptor)
            throws WSDLException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

            // TODO : Check if it is a Thread safe method
            final JAXBElement element = new JAXBElement(new QName(Constants.WSDL_11_NAMESPACE,
                    Constants.WSDL11_ROOT_TAG), wsdlDescriptor.getClass(), wsdlDescriptor);

            WSDLWriterImpl.marshaller.marshal(element, doc);
        } catch (final JAXBException ex) {
            throw new WSDLException(
                    "Failed to build XML binding from WSDL descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSDLException(
                    "Failed to build XML binding from WSDL descriptor Java classes", ex);

        }
        return doc;
    }

    @SuppressWarnings("unchecked")
    private static String convertWSDL11Definition2String(final TDefinitions wsdlDescriptor)
            throws WSDLException {

        try {
            final StringWriter stringWriter = new StringWriter();
            // TODO : Check if it is a Thread safe method

            final JAXBElement element = new JAXBElement(new QName(Constants.WSDL_11_NAMESPACE,
                    Constants.WSDL11_ROOT_TAG), wsdlDescriptor.getClass(), wsdlDescriptor);

            WSDLWriterImpl.marshaller.marshal(element, stringWriter);

            return stringWriter.toString();
        } catch (final JAXBException e) {
            throw new WSDLException(
                    "Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    /**
     * Get the marshaller instance.
     * 
     * @return the marshaller instance
     * @throws WSDLException
     *             The exception raised during the marshaller creation.
     */
    public static Marshaller getMarshaller() throws WSDLException {

        if (WSDLWriterImpl.marshallerCreationEx != null) {
            throw WSDLWriterImpl.marshallerCreationEx;
        }

        return WSDLWriterImpl.marshaller;
    }

    public Document getDocument(final Description wsdlDef) throws WSDLException {
        Document doc = null;
        if ((wsdlDef != null)
                && (wsdlDef instanceof com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl)) {
            try {
                doc = WSDLWriterImpl.convertWSDL11Definition2DOMElement(((com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl) wsdlDef)
                        .getModel());
                doc.setDocumentURI(wsdlDef.getDocumentBaseURI().getPath());
            } catch (final WSDLException e) {
                throw new WSDLException("Can not write wsdl description", e);
            }
        }
        return doc;
    }

    public boolean getFeature(final String name) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public String writeWSDL(final Description wsdlDef) throws WSDLException {
        String res = null;
        if ((wsdlDef != null)
                && (wsdlDef instanceof com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl)) {
            try {
                res = WSDLWriterImpl.convertWSDL11Definition2String(((com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl) wsdlDef)
                        .getModel());
            } catch (final WSDLException e) {
                throw new WSDLException("Can not write wsdl description", e);
            }
        }
        return res;
    }

}
