/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.xmlsoap.schemas.wsdl.soap.THeaderFault;
import org.xmlsoap.schemas.wsdl.soap.THeaderFault.EncodingStyleItem;

import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.SOAPBinding4Wsdl11.UseConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SOAP11HeaderFaultImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap11.SOAP11HeaderFault {

    private final THeaderFault headerFault;

    public SOAP11HeaderFaultImpl(final THeaderFault headerFault) {
        this.headerFault = headerFault;

    }

    public List<String> getEncodingStyles() {
        List<String> res = null;
        if ((this.headerFault.getEncodingStyleItems() != null)
                && (this.headerFault.getEncodingStyleItems().size() > 0)) {
            res = new ArrayList<String>();
            for (final EncodingStyleItem item : this.headerFault.getEncodingStyleItems()) {
                res.add(item.getItem());
            }
        }
        return res;
    }

    public String getNamespace() {
        return this.headerFault.getNamespace();
    }

    public UseConstants getUse() {
        UseConstants res = null;
        if (this.headerFault.getUse() != null) {
            res = UseConstants.valueOf(this.headerFault.getUse().value());
        }
        return res;
    }

    public QName getMessage() {
        return this.headerFault.getMessage();
    }

    public String getPart() {
        return this.headerFault.getPart();
    }

}
