/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap12;

import java.util.ArrayList;
import java.util.List;

import org.xmlsoap.schemas.wsdl.soap12.TBody;
import org.xmlsoap.schemas.wsdl.soap12.TFault;
import org.xmlsoap.schemas.wsdl.soap12.THeader;

import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Body;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Fault;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Header;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SOAP12BindingImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Binding4Wsdl11 {

    SOAP12Body soap12body = null;

    List<SOAP12Header> soap12headers = new ArrayList<SOAP12Header>();

    SOAP12Fault soap12fault = null;

    public SOAP12BindingImpl(final List<THeader> headers, final TBody body, final TFault fault) {
        if (headers != null) {
            for (final THeader h : headers) {
                this.soap12headers
                        .add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap12.SOAP12HeaderImpl(
                                h));
            }
        }
        if (body != null) {
            this.soap12body = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap12.SOAP12BodyImpl(
                    body);
        }
        if (fault != null) {
            this.soap12fault = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap12.SOAP12FaultImpl(
                    fault);
        }
    }

    public List<SOAP12Header> getHeaders() {
        return this.soap12headers;
    }

    public SOAP12Body getBody() {
        return this.soap12body;
    }

    public SOAP12Fault getFault() {
        return this.soap12fault;
    }

}
