/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.w3.ns.wsdl.BindingOperationType;
import org.w3.ns.wsdl.BindingType;
import org.w3c.dom.Element;

import com.ebmwebsourcing.commons.wsdl.api.BindingOperation;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractBindingImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BindingImpl extends AbstractBindingImpl<BindingType> implements
        com.ebmwebsourcing.commons.wsdl.api.Binding {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    private static Logger log = Logger.getLogger(BindingImpl.class.getName());

    @SuppressWarnings("unchecked")
    public BindingImpl(final BindingType binding, final DescriptionImpl desc) {
        this.model = binding;
        this.desc = desc;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());

        // get the interface
        final QName itfName = this.model.getInterface();
        this.itf = this.desc.getInterface(itfName);

        // get the binding operation
        for (final Object element : this.model.getOperationOrFaultOrAny()) {

            if (element instanceof JAXBElement) {
                final Object part = ((JAXBElement) element).getValue();

                // get binding operation
                if (part instanceof BindingOperationType) {
                    final BindingOperation bo = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.BindingOperationImpl(
                            (BindingOperationType) part, this);
                    this.bindingOperations.add(bo);
                }
            }
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addBindingOperation(final BindingOperation bindingOperation) {
        super.addBindingOperation(bindingOperation);
        this.model.getOperationOrFaultOrAny().add(
                ((AbstractWSDLElementImpl) bindingOperation).getModel());
    }

    public QName getQName() {
        return new QName(this.desc.getTargetNamespace(), this.model.getName());
    }

    public BindingOperation removeBindingOperation(final String name) {
        throw new NotImplementedException();
    }

    public void setInterface(final InterfaceType interfaceType) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        throw new NotImplementedException();
    }

    public String getTransportProtocol() {
        String protocol = null;
        for (final Entry<QName, String> attribute : this.model.getOtherAttributes().entrySet()) {
            if ((attribute.getKey().getLocalPart().equals(Constants.SOAP_PROTOCOL))
                    && (attribute.getKey().getNamespaceURI()
                            .equals(com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.SOAP_BINDING4WSDL20
                                    .value().toString()))) {
                protocol = attribute.getValue();
                break;
            } else if (((attribute.getKey().getLocalPart().equals(Constants.HTTP_METHOD)) || (attribute
                    .getKey().getLocalPart().equals(Constants.HTTP_METHOD_DEFAULT)))
                    && ((attribute.getKey().getNamespaceURI()
                            .equals(com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                    .value().toString())))) {
                protocol = attribute.getValue();
                break;
            }
        }
        return protocol;
    }

    public void setTransportProtocol() {
        throw new NotImplementedException();
    }

    public StyleConstant getStyle() {
        return StyleConstant.DOCUMENT;
    }

    public BindingConstants getTypeOfBinding() {
        BindingConstants res = null;
        try {
            if (this.model.getType() != null) {
                res = BindingConstants.valueOf(new URI(this.model.getType()));
            }
        } catch (final URISyntaxException e) {
            BindingImpl.log.warning("The binding type is unknown");
        }
        return res;
    }

    public String getVersion() {
        String res = null;
        res = this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "version"));
        if (res == null) {
            res = this.model
                    .getOtherAttributes()
                    .get(
                            new QName(
                                    com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.SOAP_BINDING4WSDL20
                                            .value().toString(), "version"));
        }
        return res;
    }

    public String getHttpContentEncodingDefault() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "contentEncodingDefault"));
    }

    public String getHttpDefaultMethod() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "methodDefault"));
    }

    public String getHttpQueryParameterSeparatorDefault() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "queryParameterSeparatorDefault"));
    }

    public boolean isHttpCookies() {
        return Boolean
                .valueOf(this.model
                        .getOtherAttributes()
                        .get(
                                new QName(
                                        com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                                .value().toString(), "cookies")));
    }
    
    public List<Element> getOtherElements() throws WSDLException {
        List<Element> res = super.getOtherElements();
    
        for(Object item: this.model.getOperationOrFaultOrAny()) {
        	if(item instanceof Element) {
        		res.add((Element) item);
        	}
        }
        
        return res;
    }
}
