/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class Constants {

    /**
     * WSDL 2.0 Namespace
     */
    public static final String WSDL_20_NAMESPACE = "http://www.w3.org/ns/wsdl";

    /**
     * WSDL 2.0 schema name
     */
    public static final String XSD_WSDL_20 = "schema/wsdl/wsdl20/wsdl20.xsd";

    /**
     * WSDL 2.0 root tag
     */
    public static final String WSDL20_ROOT_TAG = "description";

    /**
     * http method default attribute in http binding
     */
    public static final String HTTP_METHOD_DEFAULT = "methodDefault";

    /**
     * http method attribute in http binding
     */
    public static final String HTTP_METHOD = "method";

    /**
     * soap protocol attribute in soap binding
     */
    public static final String SOAP_PROTOCOL = "protocol";

    /**
     * soap mep attribute in soap binding
     */
    public static final String MEP_ATTRIBUTE = "mep";

    /**
     * Errors
     */
    public static final String NOT_SUPPORTED = "the WSDL 2.0 model does not support this operation";
}
