/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.w3.ns.wsdl.MessageRefFaultType;

import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.wsdl.api.Part;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractOperationImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractParamImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class FaultImpl extends AbstractParamImpl<MessageRefFaultType> implements
        com.ebmwebsourcing.commons.wsdl.api.Fault {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public FaultImpl(final MessageRefFaultType param, final OperationImpl operationImpl) {
        this.model = param;
        this.operation = operationImpl;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());

        // get element name
        this.elementName = param.getRef();
    }

    @SuppressWarnings("unchecked")
    public QName getMessageName() {
        QName res = null;
        if (this.model.getMessageLabel() != null) {
            res = new QName(((AbstractInterfaceTypeImpl) ((AbstractOperationImpl) this
                    .getOperation()).getInterface()).getDescription().getTargetNamespace(),
                    this.model.getMessageLabel());
        } else {
            res = new QName(((AbstractInterfaceTypeImpl) ((AbstractOperationImpl) this
                    .getOperation()).getInterface()).getDescription().getTargetNamespace(), "Out");
        }
        return res;
    }

    public void setMessageName(final QName name) {
        this.model.setMessageLabel(name.getLocalPart());
    }

    public List<Part> getParts() {
        return null;
    }

    public void setElement(final Element element) {
        throw new NotImplementedException();
    }

    public String getName() {
        return null;
    }

    public void setName(final String name) throws WSDLException {
        throw new WSDLException(Constants.NOT_SUPPORTED);
    }

    public Part getPart(final String name) {
        return null;
    }
    
    public List<org.w3c.dom.Element> getOtherElements() throws WSDLException {
        List<org.w3c.dom.Element> res = super.getOtherElements();
    
        for(Object item: this.model.getAny()) {
        	if(item instanceof org.w3c.dom.Element) {
        		res.add((org.w3c.dom.Element) item);
        	}
        }
        
        return res;
    }
}
