/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.w3.ns.wsdl.InterfaceOperationType;
import org.w3c.dom.Element;

import com.ebmwebsourcing.commons.wsdl.api.Operation;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class InterfaceTypeImpl extends AbstractInterfaceTypeImpl<org.w3.ns.wsdl.InterfaceType>
        implements com.ebmwebsourcing.commons.wsdl.api.InterfaceType {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    @SuppressWarnings("unchecked")
    public InterfaceTypeImpl(final org.w3.ns.wsdl.InterfaceType itf, final DescriptionImpl desc) {
        this.model = itf;
        this.desc = desc;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());

        // get the operations
        for (final Object element : this.model.getOperationOrFaultOrAny()) {

            if (element instanceof JAXBElement) {
                final Object part = ((JAXBElement) element).getValue();

                // get binding operation
                if (part instanceof InterfaceOperationType) {
                    final Operation op = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.OperationImpl(
                            (InterfaceOperationType) part, this);
                    this.operations.add(op);
                }
            }
        }

    }

    public QName getQName() {
        return new QName(this.getDescription().getTargetNamespace(), this.model.getName());
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addOperation(final Operation op) {
        super.addOperation(op);
        this.model.getOperationOrFaultOrAny().add(((AbstractWSDLElementImpl) op).getModel());
    }

    public Operation removeOperation(final String name) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        throw new NotImplementedException();
    }

    public List<Element> getOtherElements() throws WSDLException {
        List<Element> res = super.getOtherElements();
    
        for(Object item: this.model.getOperationOrFaultOrAny()) {
        	if(item instanceof Element) {
        		res.add((Element) item);
        	}
        }
        
        return res;
    }
}
