/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.io.IOException;
import java.net.URL;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

import com.ebmwebsourcing.commons.wsdl.api.WSDLException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class WSDLJAXBContext {

    /**
     * The JAXB context
     */
    private static JAXBContext jaxbContext;

    /**
     * Private object initializations
     */
    protected static void createContext() throws WSDLException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        
        
        final URL schemaUrl20 = WSDLJAXBContext.class.getResource("/" + Constants.XSD_WSDL_20);

        try {
            factory.newSchema(new StreamSource[] { new StreamSource(schemaUrl20.openStream()), });

            WSDLJAXBContext.jaxbContext = JAXBContext.newInstance(new Class[] { org.w3.ns.wsdl.ObjectFactory.class,
                    org.w3.ns.wsdl.http.ObjectFactory.class,
                    org.w3.ns.wsdl.rpc.ObjectFactory.class,
                    org.w3.ns.wsdl.soap.ObjectFactory.class,
                    org.w3._2003._05.soap_encoding.ObjectFactory.class,
                    org.w3._2003._05.soap_envelope.ObjectFactory.class,
                    org.w3._2001.xmlschema.ObjectFactory.class });

        } catch (final SAXException e) {
            throw new WSDLException(e);
        } catch (final IOException e) {
            throw new WSDLException(e);
        } catch (final JAXBException e) {
            throw new WSDLException(e);
        }

    }

    /**
     * @return the jaxbContext
     */
    public static JAXBContext getJaxbContext() {
        return WSDLJAXBContext.jaxbContext;
    }
}
