/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20.binding.soap;

import java.util.ArrayList;
import java.util.List;

import org.w3.ns.wsdl.soap.Header;
import org.w3.ns.wsdl.soap.Module;

import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl20.soap.SOAPHeader;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl20.soap.SOAPModule;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SOAPBindingImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl20.soap.SOAPBinding4Wsdl20 {

    private final List<SOAPHeader> soapHeaders = new ArrayList<SOAPHeader>();

    private final List<SOAPModule> soapModules = new ArrayList<SOAPModule>();

    public SOAPBindingImpl(final List<Header> headers, final List<Module> modules) {
        for (final Header header : headers) {
            this.soapHeaders
                    .add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.binding.soap.SOAPHeaderImpl(
                            header));
        }
        for (final Module module : modules) {
            this.soapModules
                    .add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.binding.soap.SOAPModuleImpl(
                            module));
        }
    }

    public List<SOAPHeader> getHeaders() {
        return this.soapHeaders;
    }

    public List<SOAPModule> getModules() {
        return this.soapModules;
    }

}
